/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan;

import org.drools.persistence.PersistenceContext;
import org.drools.persistence.info.EntityHolder;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.infinispan.Cache;

public class InfinispanPersistenceContext
implements PersistenceContext {
    private static long SESSIONINFO_KEY = 1L;
    private static long WORKITEMINFO_KEY = 1L;
    private static final Object syncObject = new Object();
    private Cache<String, Object> cache;
    private boolean isJTA;

    public InfinispanPersistenceContext(Cache<String, Object> cache) {
        this(cache, true);
    }

    public InfinispanPersistenceContext(Cache<String, Object> cache, boolean isJTA) {
        this.cache = cache;
        this.isJTA = isJTA;
    }

    public SessionInfo persist(SessionInfo entity) {
        if (entity.getId() == null) {
            entity.setId(this.generateSessionInfoId());
        }
        String key = this.createSessionKey(entity.getId());
        entity.transform();
        this.cache.put((Object)key, (Object)new EntityHolder(key, entity));
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long generateSessionInfoId() {
        Object object = syncObject;
        synchronized (object) {
            while (this.cache.containsKey((Object)("sessionInfo" + SESSIONINFO_KEY))) {
                ++SESSIONINFO_KEY;
            }
        }
        return SESSIONINFO_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long generateWorkItemInfoId() {
        Object object = syncObject;
        synchronized (object) {
            while (this.cache.containsKey((Object)("workItem" + WORKITEMINFO_KEY))) {
                ++WORKITEMINFO_KEY;
            }
        }
        return WORKITEMINFO_KEY;
    }

    private String createSessionKey(Long id) {
        return "sessionInfo" + this.safeId(id);
    }

    private String createWorkItemKey(Long id) {
        return "workItem" + this.safeId(id);
    }

    private String safeId(Number id) {
        return String.valueOf(id);
    }

    public SessionInfo findSessionInfo(Long id) {
        EntityHolder holder = (EntityHolder)this.cache.get((Object)this.createSessionKey(id));
        if (holder == null) {
            return null;
        }
        return holder.getSessionInfo();
    }

    public void remove(SessionInfo sessionInfo) {
        this.cache.remove((Object)this.createSessionKey(sessionInfo.getId()));
        this.cache.evict((Object)this.createSessionKey(sessionInfo.getId()));
    }

    public boolean isOpen() {
        return true;
    }

    public void joinTransaction() {
        if (this.isJTA) {
            // empty if block
        }
    }

    public void close() {
    }

    public WorkItemInfo persist(WorkItemInfo workItemInfo) {
        if (workItemInfo.getId() == null) {
            workItemInfo.setId(this.generateWorkItemInfoId());
        }
        String key = this.createWorkItemKey(workItemInfo.getId());
        workItemInfo.transform();
        this.cache.put((Object)key, (Object)new EntityHolder(key, workItemInfo));
        return workItemInfo;
    }

    public WorkItemInfo findWorkItemInfo(Long id) {
        EntityHolder holder = (EntityHolder)this.cache.get((Object)this.createWorkItemKey(id));
        if (holder == null) {
            return null;
        }
        return holder.getWorkItemInfo();
    }

    public void remove(WorkItemInfo workItemInfo) {
        this.cache.remove((Object)this.createWorkItemKey(workItemInfo.getId()));
        this.cache.evict((Object)this.createWorkItemKey(workItemInfo.getId()));
    }

    public WorkItemInfo merge(WorkItemInfo workItemInfo) {
        String key = this.createWorkItemKey(workItemInfo.getId());
        workItemInfo.transform();
        return ((EntityHolder)this.cache.put((Object)key, (Object)new EntityHolder(key, workItemInfo))).getWorkItemInfo();
    }

    public Cache<String, Object> getCache() {
        return this.cache;
    }

    public void lock(WorkItemInfo workItemInfo) {
    }
}

