/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan;

import java.lang.reflect.Field;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.fluent.impl.InternalExecutable;
import org.drools.core.runtime.InternalLocalRunner;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.SessionMarshallingHelper;
import org.drools.persistence.info.SessionInfo;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.RequestContext;

public class ManualPersistInterceptor
extends AbstractInterceptor {
    private final SingleSessionCommandService interceptedService;

    public ManualPersistInterceptor(SingleSessionCommandService decorated) {
        this.interceptedService = decorated;
    }

    public RequestContext execute(Executable executable, RequestContext ctx) {
        this.executeNext(executable, (Context)ctx);
        try {
            KieSession ksession = this.interceptedService.getKieSession();
            Field sessionInfoField = PersistableRunner.class.getDeclaredField("sessionInfo");
            sessionInfoField.setAccessible(true);
            Field jpmField = PersistableRunner.class.getDeclaredField("jpm");
            jpmField.setAccessible(true);
            Object jpm = jpmField.get(this.interceptedService);
            Object sessionInfo = sessionInfoField.get(this.interceptedService);
            if (((InternalExecutable)executable).canRunInTransaction()) {
                this.executeNext((Executable)new InternalLocalRunner.SingleCommandExecutable((Command)new PersistCommand(sessionInfo, jpm, ksession)), (Context)ctx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't force persistence of session info", e);
        }
        return ctx;
    }

    public SingleSessionCommandService getInterceptedService() {
        return this.interceptedService;
    }

    public static class PersistCommand
    implements ExecutableCommand<Void> {
        private final SessionInfo sessionInfo;
        private final PersistenceContext persistenceContext;
        private final KieSession ksession;

        public PersistCommand(Object sessionInfo, Object jpm, KieSession ksession) {
            this.sessionInfo = (SessionInfo)sessionInfo;
            this.persistenceContext = ((PersistenceContextManager)jpm).getApplicationScopedPersistenceContext();
            this.ksession = ksession;
        }

        public Void execute(Context context) {
            if (this.sessionInfo.getJPASessionMashallingHelper() == null) {
                this.sessionInfo.setJPASessionMashallingHelper(new SessionMarshallingHelper(this.ksession.getKieBase(), this.ksession.getSessionConfiguration(), this.ksession.getEnvironment()));
            }
            this.sessionInfo.transform();
            this.persistenceContext.persist(this.sessionInfo);
            return null;
        }
    }
}

