/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.cache;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.cache.EfestoIdentifierClassKey;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;

class EfestoIdentifierClassKeyTest {
    EfestoIdentifierClassKeyTest() {
    }

    @Test
    void sameIdentifierSameClass() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId modelLocalUriId1 = new ModelLocalUriId(parsed);
        ModelLocalUriId modelLocalUriId2 = new ModelLocalUriId(parsed);
        EfestoClassKey keyListString1 = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoClassKey keyListString2 = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoIdentifierClassKey identifierKeyListString1 = new EfestoIdentifierClassKey(modelLocalUriId1, keyListString1);
        EfestoIdentifierClassKey identifierKeyListString2 = new EfestoIdentifierClassKey(modelLocalUriId2, keyListString2);
        Assertions.assertThat((Object)identifierKeyListString1).isEqualTo((Object)identifierKeyListString2);
    }

    @Test
    void sameIdentifierDifferentClass() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId modelLocalUriId1 = new ModelLocalUriId(parsed);
        ModelLocalUriId modelLocalUriId2 = new ModelLocalUriId(parsed);
        EfestoClassKey keyListString = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoClassKey keyArrayListString = new EfestoClassKey(ArrayList.class, new Type[]{String.class});
        EfestoIdentifierClassKey identifierKeyListString1 = new EfestoIdentifierClassKey(modelLocalUriId1, keyListString);
        EfestoIdentifierClassKey identifierKeyListString2 = new EfestoIdentifierClassKey(modelLocalUriId2, keyArrayListString);
        Assertions.assertThat((Object)identifierKeyListString1).isNotEqualTo((Object)identifierKeyListString2);
    }

    @Test
    void differentIdentifierSameClass() {
        String path1 = "/example/some-id/instances/some-instance-id";
        LocalUri parsed1 = LocalUri.parse((String)path1);
        ModelLocalUriId modelLocalUriId1 = new ModelLocalUriId(parsed1);
        String path2 = "/example/some-id/instances/another-instance-id";
        LocalUri parsed2 = LocalUri.parse((String)path2);
        ModelLocalUriId modelLocalUriId2 = new ModelLocalUriId(parsed2);
        EfestoClassKey keyListString1 = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoClassKey keyListString2 = new EfestoClassKey(List.class, new Type[]{String.class});
        EfestoIdentifierClassKey identifierKeyListString1 = new EfestoIdentifierClassKey(modelLocalUriId1, keyListString1);
        EfestoIdentifierClassKey identifierKeyListString2 = new EfestoIdentifierClassKey(modelLocalUriId2, keyListString2);
        Assertions.assertThat((Object)identifierKeyListString1).isNotEqualTo((Object)identifierKeyListString2);
    }
}

