/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.io;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.utils.MemoryFileUtils;

class IndexFileTest {
    private static IndexFile testingFile;

    IndexFileTest() {
    }

    @BeforeAll
    public static void setup() {
        testingFile = MemoryFileUtils.getFileFromFileNameOrFilePath((String)"IndexFile.test_json", (String)"./IndexFile.test_json").map(IndexFile::new).orElseThrow(() -> new RuntimeException("Failed to retrieve IndexFile.test_json"));
    }

    @Test
    void validatePathName() {
        String toValidate = String.format("%1$sthis%1$sis%1$svalid%1$sfile.model_json", File.separator);
        Assertions.assertThat((String)IndexFile.validatePathName((String)toValidate)).isEqualTo(toValidate);
    }

    @Test
    void validateWrongPathName() {
        String toValidate1 = String.format("%1$sthis%1$sis%1$sinvalid%1$sfile._json", File.separator);
        String toValidate2 = String.format("%1$sthis%1$sis%1$sinvalid%1$sfile.model", File.separator);
        List<String> toValidate = Arrays.asList(toValidate1, toValidate2);
        toValidate.forEach(toVal -> {
            String fileName = toVal.substring(toVal.lastIndexOf(File.separator) + 1);
            String expectedMessage = String.format("Wrong file name %s", fileName);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IndexFile.validatePathName((String)toVal)).isInstanceOf(KieEfestoCommonException.class)).hasMessage(expectedMessage);
        });
    }

    @Test
    void getModel() {
        String fileName = "file_name.model_json";
        String expected = "model";
        Object source = fileName;
        Assertions.assertThat((String)IndexFile.getModel((String)source)).isEqualTo(expected);
        source = File.separator + "dir" + File.separator + fileName;
        Assertions.assertThat((String)IndexFile.getModel((String)source)).isEqualTo(expected);
    }

    @Test
    void testGetModel() {
        String fileName = String.format("%1$sthis%1$sis%1$svalid%1$sfile.model_json", File.separator);
        String expected = "model";
        IndexFile indexFile = new IndexFile(fileName);
        Assertions.assertThat((String)indexFile.getModel()).isEqualTo(expected);
    }

    @Test
    void isEqualExisting() {
        IndexFile compareFile = MemoryFileUtils.getFileByFilePath((String)"./target/test-classes/IndexFile.test_json").map(IndexFile::new).orElseThrow(() -> new RuntimeException("Failed to retrieve IndexFile.test_json"));
        Assertions.assertThat((String)compareFile.getName()).isEqualTo(testingFile.getName());
        Assertions.assertThat((String)compareFile.getPath()).isNotEqualTo((Object)testingFile.getPath());
        Assertions.assertThat((String)compareFile.getAbsolutePath()).isNotEqualTo((Object)testingFile.getAbsolutePath());
        Assertions.assertThat((boolean)compareFile.equals((Object)testingFile)).isTrue();
    }

    @Test
    void isEqualNotExisting() {
        String expected = "model";
        IndexFile indexFile = new IndexFile("not/exist/", expected);
        IndexFile compareFile = new IndexFile("not/exist/", expected);
        Assertions.assertThat((String)compareFile.getName()).isEqualTo(indexFile.getName());
        Assertions.assertThat((String)compareFile.getPath()).isEqualTo(indexFile.getPath());
        Assertions.assertThat((String)compareFile.getAbsolutePath()).isEqualTo(indexFile.getAbsolutePath());
        Assertions.assertThat((boolean)compareFile.equals((Object)indexFile)).isTrue();
    }

    @Test
    void isEqualMixed() {
        IndexFile compareFile = new IndexFile("not/exist/", "test");
        Assertions.assertThat((String)compareFile.getName()).isEqualTo(testingFile.getName());
        Assertions.assertThat((boolean)compareFile.equals((Object)testingFile)).isFalse();
    }
}

