/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.model;

import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.identifiers.ReflectiveAppRoot;
import org.kie.efesto.common.api.identifiers.componentroots.ComponentRootA;
import org.kie.efesto.common.api.identifiers.componentroots.ComponentRootB;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedResources;

class GeneratedResourcesTest {
    private static String fullClassName;
    private static String model;
    private static LocalUri firstLocalUri;
    private static ModelLocalUriId firstModelLocalUriId;
    private static LocalUri secondLocalUri;
    private static ModelLocalUriId secondModelLocalUriId;

    GeneratedResourcesTest() {
    }

    @BeforeAll
    public static void setup() {
        fullClassName = "full.class.Path";
        model = "foo";
        firstLocalUri = ((ComponentRootB)new ReflectiveAppRoot(model).get(ComponentRootB.class)).get("this", "is", "localUri").asLocalUri();
        firstModelLocalUriId = new ModelLocalUriId(firstLocalUri);
        secondLocalUri = ((ComponentRootA)new ReflectiveAppRoot(model).get(ComponentRootA.class)).get("this", "different-localUri").asLocalUri();
        secondModelLocalUriId = new ModelLocalUriId(secondLocalUri);
    }

    @Test
    void addDifferentGeneratedResourcesClasses() {
        GeneratedClassResource generatedClassResource = new GeneratedClassResource(fullClassName);
        GeneratedExecutableResource generatedFinalResource = new GeneratedExecutableResource(firstModelLocalUriId, Collections.singletonList(fullClassName));
        GeneratedResources generatedResources = new GeneratedResources();
        generatedResources.add((Object)generatedClassResource);
        generatedResources.add((Object)generatedFinalResource);
        Assertions.assertThat((Collection)generatedResources).hasSize(2);
        Assertions.assertThat((boolean)generatedResources.contains((Object)generatedClassResource)).isTrue();
        Assertions.assertThat((boolean)generatedResources.contains((Object)generatedFinalResource)).isTrue();
    }

    @Test
    void addEqualsGeneratedResources() {
        GeneratedResources generatedResources = new GeneratedResources();
        generatedResources.add((Object)new GeneratedExecutableResource(firstModelLocalUriId, Collections.singletonList(fullClassName)));
        generatedResources.add((Object)new GeneratedExecutableResource(firstModelLocalUriId, Collections.singletonList(fullClassName)));
        Assertions.assertThat((Collection)generatedResources).hasSize(1);
    }

    @Test
    void addDifferentGeneratedResourcesIds() {
        GeneratedExecutableResource firstExecutableResource = new GeneratedExecutableResource(firstModelLocalUriId, Collections.singletonList(fullClassName));
        GeneratedExecutableResource secondExecutableResource = new GeneratedExecutableResource(secondModelLocalUriId, Collections.singletonList(fullClassName));
        GeneratedResources generatedResources = new GeneratedResources();
        generatedResources.add((Object)firstExecutableResource);
        generatedResources.add((Object)secondExecutableResource);
        Assertions.assertThat((Collection)generatedResources).hasSize(2);
        Assertions.assertThat((boolean)generatedResources.contains((Object)firstExecutableResource)).isTrue();
        Assertions.assertThat((boolean)generatedResources.contains((Object)secondExecutableResource)).isTrue();
    }
}

