/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.runtimemanager.api.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPIUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)SPIUtils.class.getName());
    private static final ServiceLoader<RuntimeManager> runtimeManagerLoader = ServiceLoader.load(RuntimeManager.class);
    private static final ServiceLoader<KieRuntimeService> kieRuntimeServiceLoader = ServiceLoader.load(KieRuntimeService.class);

    private SPIUtils() {
    }

    public static Optional<KieRuntimeService> getKieRuntimeService(EfestoInput<?> darInput, boolean refresh, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        logger.debug("getKieRuntimeService {} {}", darInput, (Object)refresh);
        List<KieRuntimeService> retrieved = SPIUtils.getKieRuntimeServices(refresh);
        return retrieved.stream().filter(service -> service.canManageInput(darInput, memoryCompilerClassLoader)).findFirst();
    }

    public static List<KieRuntimeService> getKieRuntimeServices(boolean refresh) {
        logger.debug("getKieRuntimeServices {}", (Object)refresh);
        ArrayList<KieRuntimeService> toReturn = new ArrayList<KieRuntimeService>();
        Iterator<KieRuntimeService> services = SPIUtils.getServices(refresh);
        services.forEachRemaining(toReturn::add);
        logger.debug("toReturn {} {}", toReturn, (Object)toReturn.size());
        if (logger.isTraceEnabled()) {
            toReturn.forEach(provider -> logger.trace("{}", provider));
        }
        return toReturn;
    }

    public static Optional<RuntimeManager> getRuntimeManager(boolean refresh) {
        logger.debug("getRuntimeManager {}", (Object)refresh);
        ArrayList toReturn = new ArrayList();
        Iterator<RuntimeManager> managers = SPIUtils.getManagers(refresh);
        managers.forEachRemaining(toReturn::add);
        return toReturn.stream().findFirst();
    }

    private static Iterator<KieRuntimeService> getServices(boolean refresh) {
        if (refresh) {
            kieRuntimeServiceLoader.reload();
        }
        return kieRuntimeServiceLoader.iterator();
    }

    private static Iterator<RuntimeManager> getManagers(boolean refresh) {
        if (refresh) {
            runtimeManagerLoader.reload();
        }
        return runtimeManagerLoader.iterator();
    }
}

