/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;

public abstract class EAPBaseTest {
    protected EAPArtifactsHolder artifactsHolder;
    @Mock
    protected Log logger;
    @Mock
    protected RepositorySystem repoSystem;
    @Mock
    protected RepositorySystemSession repoSession;
    @Mock
    protected List<RemoteRepository> remoteRepos;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        EAPArtifactsHolder artifactsHolder = new EAPArtifactsHolder(this.repoSystem, this.repoSession, this.remoteRepos);
        this.artifactsHolder = (EAPArtifactsHolder)Mockito.spy((Object)artifactsHolder);
        ((EAPArtifactsHolder)Mockito.doNothing().when((Object)this.artifactsHolder)).setModule((Artifact)Matchers.any(Artifact.class), (EAPModule)Matchers.any(EAPModule.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).debug((CharSequence)Matchers.anyString());
        ((Log)Mockito.doNothing().when((Object)this.logger)).debug((CharSequence)Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).debug((Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).info((CharSequence)Matchers.anyString());
        ((Log)Mockito.doNothing().when((Object)this.logger)).info((CharSequence)Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).info((Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).warn((CharSequence)Matchers.anyString());
        ((Log)Mockito.doNothing().when((Object)this.logger)).warn((CharSequence)Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).warn((Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).error((CharSequence)Matchers.anyString());
        ((Log)Mockito.doNothing().when((Object)this.logger)).error((CharSequence)Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
        ((Log)Mockito.doNothing().when((Object)this.logger)).error((Throwable)Matchers.any(Throwable.class));
    }

    protected void initMockArtifact(Artifact artifact, String groupId, String artifactId, String version, String type, String classifier) {
        Assert.assertTrue((artifact != null ? 1 : 0) != 0);
        Assert.assertTrue((groupId != null ? 1 : 0) != 0);
        Assert.assertTrue((artifactId != null ? 1 : 0) != 0);
        Mockito.when((Object)artifact.getGroupId()).thenReturn((Object)groupId);
        Mockito.when((Object)artifact.getArtifactId()).thenReturn((Object)artifactId);
        Mockito.when((Object)artifact.getVersion()).thenReturn((Object)(version != null ? version : ""));
        Mockito.when((Object)artifact.getExtension()).thenReturn((Object)(type != null ? type : ""));
        Mockito.when((Object)artifact.getClassifier()).thenReturn((Object)(classifier != null ? classifier : ""));
    }

    protected void initMockArtifact(Artifact pomArtifact, String groupId, String artifactId, String version, String type, String classifier, String fileUri) throws Exception {
        this.initMockArtifact(pomArtifact, groupId, artifactId, version, type, classifier);
        URL droolsStaticModulePomFileUrl = this.getClass().getResource(fileUri);
        File droolsStaticModulePomFile = new File(droolsStaticModulePomFileUrl.toURI());
        Mockito.when((Object)pomArtifact.getFile()).thenReturn((Object)droolsStaticModulePomFile);
    }

    protected void initMockModule(EAPModule module, String moduleName, String moduleSlot, Artifact modulePomArtifact) {
        Assert.assertTrue((module != null ? 1 : 0) != 0);
        Assert.assertTrue((moduleName != null ? 1 : 0) != 0);
        Mockito.when((Object)module.getName()).thenReturn((Object)moduleName);
        Mockito.when((Object)module.getSlot()).thenReturn((Object)(moduleSlot != null ? moduleSlot : "main"));
        Mockito.when((Object)module.getUniqueId()).thenReturn((Object)(moduleSlot != null ? moduleName + ":" + moduleSlot : moduleName + ":main"));
        Mockito.when((Object)module.getArtifact()).thenReturn((Object)modulePomArtifact);
    }

    protected void initMockModule(EAPModule module, String moduleName, String moduleSlot, Artifact modulePomArtifact, Collection<EAPModuleResource> resources) {
        this.initMockModule(module, moduleName, moduleSlot, modulePomArtifact);
        Mockito.when((Object)module.getResources()).thenReturn(resources);
    }

    protected void initMockModuleResource(EAPModuleResource resource, String resourceName, String resourceFileName, Artifact resourceArtifact) {
        Assert.assertTrue((resource != null ? 1 : 0) != 0);
        Mockito.when((Object)resource.getName()).thenReturn((Object)resourceName);
        Mockito.when((Object)resource.getFileName()).thenReturn((Object)resourceFileName);
        Mockito.when((Object)resource.getResource()).thenReturn((Object)(resourceArtifact != null ? 1 : 0));
        Mockito.when((Object)resource.getExclusions()).thenReturn(null);
    }

    protected void initMockLayer(EAPLayer layer, String layerName, Collection<EAPModule> modules) {
        Assert.assertTrue((layer != null ? 1 : 0) != 0);
        Assert.assertTrue((layerName != null ? 1 : 0) != 0);
        Mockito.when((Object)layer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)layer.getProperties()).thenReturn(null);
        if (modules != null && !modules.isEmpty()) {
            Mockito.when((Object)layer.getModules()).thenReturn(modules);
            for (EAPModule module : modules) {
                Artifact artifact = module.getArtifact();
                String uniqueId = module.getUniqueId();
                Mockito.when((Object)layer.getModule(artifact)).thenReturn((Object)module);
                Mockito.when((Object)layer.getModule(uniqueId)).thenReturn((Object)module);
            }
        }
    }

    protected void addArtifactIntoHolder(Artifact artifact) throws Exception {
        ((EAPArtifactsHolder)Mockito.doReturn((Object)artifact).when((Object)this.artifactsHolder)).getArtifact((Artifact)Matchers.argThat((Matcher)new EAPArtifactMatcher(artifact)));
        ((EAPArtifactsHolder)Mockito.doReturn((Object)artifact).when((Object)this.artifactsHolder)).resolveArtifact((Artifact)Matchers.argThat((Matcher)new EAPArtifactMatcher(artifact)));
    }

    protected void addArtifactIntoHolder(Artifact artifact, EAPModule module) throws Exception {
        this.addArtifactIntoHolder(artifact);
        ((EAPArtifactsHolder)Mockito.doReturn((Object)module).when((Object)this.artifactsHolder)).getModule((Artifact)Matchers.argThat((Matcher)new EAPArtifactMatcher(artifact)));
    }

    protected void cleanArtifactsInHolder() throws Exception {
        ((EAPArtifactsHolder)Mockito.doReturn(null).when((Object)this.artifactsHolder)).getArtifact((Artifact)Matchers.any(Artifact.class));
        ((EAPArtifactsHolder)Mockito.doReturn(null).when((Object)this.artifactsHolder)).resolveArtifact((Artifact)Matchers.any(Artifact.class));
        ((EAPArtifactsHolder)Mockito.doReturn(null).when((Object)this.artifactsHolder)).getModule((Artifact)Matchers.any(Artifact.class));
    }

    public static class EAPArtifactMatcher
    extends ArgumentMatcher<Artifact> {
        private Artifact artifact;

        public EAPArtifactMatcher(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean matches(Object argument) {
            return EAPArtifactUtils.equals((Artifact)((Artifact)argument), (Artifact)this.artifact);
        }
    }
}

