/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.util.ArrayList;
import org.eclipse.aether.artifact.Artifact;
import org.junit.Before;
import org.kie.integration.eap.maven.EAPBaseLayerTest;
import org.kie.integration.eap.maven.model.dependency.EAPBaseModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPCustomModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class EAPStaticLayerTest
extends EAPBaseLayerTest {
    protected static final String MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_XML = "/modules/static/drools/org.drools-static-module-pom.xml";
    protected static final String MODULES_STATIC_ORG_JBPM_STATIC_MODULE_POM_XML = "/modules/static/jbpm/pom.xml";
    protected static final String STATIC_MODULE_GROUPID = "org.kie";
    protected static final String STATIC_LAYER_NAME = "staticLayer";
    protected static final String DROOLS_MODULE_ARTIFACTID = "org-drools";
    protected static final String DROOLS_MODULE_VERSION = "1.0";
    protected static final String DROOLS_RESOURCES_GROUPID = "org.drools";
    protected static final String DROOLS_TEMPLATES_RESOURCE_ARTIFACTID = "drools-templates";
    protected static final String DROOLS_DECISION_TABLES_RESOURCE_ARTIFACTID = "drools-decisiontables";
    protected static final String DROOLS_TEMPLATES_RESOURCE_NAME = "org.drools:drools-templates:jar";
    protected static final String DROOLS_DECISION_TABLES_RESOURCE_NAME = "org.drools:drools-decisiontables:jar";
    protected static final String DROOLS_MODULE_NAME = "org.drools";
    protected static final String DROOLS_MODULE_SLOT = "1.0";
    protected static final String JBPM_MODULE_ARTIFACTID = "org-jbpm";
    protected static final String JBPM_MODULE_VERSION = "1.0";
    protected static final String JBPM_RESOURCES_GROUPID = "org.jbpm";
    protected static final String JBPM_EXECUTOR_ARTIFACTID = "jbpm-executor";
    protected static final String JBPM_JPA_RESOURCE_ARTIFACTID = "jbpm-persistence";
    protected static final String JBPM_EXECUTOR_RESOURCE_NAME = "org-jbpm:jbpm-executor:jar";
    protected static final String JBPM_JPA_RESOURCE_RESOURCE_NAME = "org-jbpm:jbpm-persistence:jar";
    protected static final String JBPM_MODULE_NAME = "org.jbpm";
    protected static final String JBPM_MODULE_SLOT = "1.0";
    @Mock
    protected Artifact droolsStaticModulePom;
    @Mock
    protected Artifact droolsTemplatesDependency;
    @Mock
    protected Artifact droolsDecisionTablesDependency;
    @Mock
    protected EAPModule droolsModule;
    @Mock
    protected EAPModuleResource droolsTemplatesResource;
    @Mock
    protected EAPModuleResource droolsDecisionTablesResource;
    @Mock
    protected Artifact jbpmStaticModulePom;
    @Mock
    protected Artifact jbpmExecutorDependency;
    @Mock
    protected Artifact jbpmJPADependency;
    @Mock
    protected EAPModule jbpmModule;
    @Mock
    protected EAPModuleResource jbpmExecutorResource;
    @Mock
    protected EAPModuleResource jbpmJPAResource;
    @Mock
    protected EAPLayer staticLayer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initDroolsStaticModule();
        ((EAPModule)Mockito.doReturn((Object)new EAPCustomModuleDependency(this.droolsModule.getName())).when((Object)this.droolsModule)).createDependency();
        this.initjBPMStaticModule();
        ((EAPModule)Mockito.doReturn((Object)new EAPCustomModuleDependency(this.jbpmModule.getName())).when((Object)this.jbpmModule)).createDependency();
        ArrayList<EAPModule> modules = new ArrayList<EAPModule>(2);
        modules.add(this.droolsModule);
        modules.add(this.jbpmModule);
        this.initMockLayer(this.staticLayer, STATIC_LAYER_NAME, modules);
    }

    protected void initDroolsStaticModule() throws Exception {
        this.initMockArtifact(this.droolsStaticModulePom, STATIC_MODULE_GROUPID, DROOLS_MODULE_ARTIFACTID, "1.0", "pom", null, MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_XML);
        this.initMockArtifact(this.droolsTemplatesDependency, "org.drools", DROOLS_TEMPLATES_RESOURCE_ARTIFACTID, null, "jar", null);
        this.initMockArtifact(this.droolsDecisionTablesDependency, "org.drools", DROOLS_DECISION_TABLES_RESOURCE_ARTIFACTID, null, "jar", null);
        this.initMockModuleResource(this.droolsTemplatesResource, DROOLS_TEMPLATES_RESOURCE_NAME, null, this.droolsTemplatesDependency);
        this.initMockModuleResource(this.droolsDecisionTablesResource, DROOLS_DECISION_TABLES_RESOURCE_NAME, null, this.droolsDecisionTablesDependency);
        ArrayList<EAPModuleResource> resources = new ArrayList<EAPModuleResource>(2);
        resources.add(this.droolsTemplatesResource);
        resources.add(this.droolsDecisionTablesResource);
        this.initMockModule(this.droolsModule, "org.drools", "1.0", this.droolsStaticModulePom, resources);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency, this.droolsModule);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency, this.droolsModule);
    }

    protected void initjBPMStaticModule() throws Exception {
        this.initMockArtifact(this.jbpmStaticModulePom, STATIC_MODULE_GROUPID, JBPM_MODULE_ARTIFACTID, "1.0", "pom", null, MODULES_STATIC_ORG_JBPM_STATIC_MODULE_POM_XML);
        this.initMockArtifact(this.jbpmExecutorDependency, "org.jbpm", JBPM_EXECUTOR_ARTIFACTID, null, "jar", null);
        this.initMockArtifact(this.jbpmJPADependency, "org.jbpm", JBPM_JPA_RESOURCE_ARTIFACTID, null, "jar", null);
        this.initMockModuleResource(this.jbpmExecutorResource, JBPM_EXECUTOR_RESOURCE_NAME, null, this.jbpmExecutorDependency);
        this.initMockModuleResource(this.jbpmJPAResource, JBPM_JPA_RESOURCE_RESOURCE_NAME, null, this.jbpmJPADependency);
        ArrayList<EAPModuleResource> resources = new ArrayList<EAPModuleResource>(2);
        resources.add(this.jbpmExecutorResource);
        resources.add(this.jbpmJPAResource);
        this.initMockModule(this.jbpmModule, "org.jbpm", "1.0", this.jbpmStaticModulePom, resources);
        this.addArtifactIntoHolder(this.jbpmExecutorDependency, this.jbpmModule);
        this.addArtifactIntoHolder(this.jbpmJPADependency, this.jbpmModule);
    }

    protected void buildStaticLayerModuleDependencies() {
        EAPModuleDependency drools_jbpmDependency = (EAPModuleDependency)Mockito.mock(EAPCustomModuleDependency.class);
        Mockito.when((Object)drools_jbpmDependency.getName()).thenReturn((Object)"org.jbpm");
        Mockito.when((Object)drools_jbpmDependency.getSlot()).thenReturn((Object)"1.0");
        EAPModuleDependency drools_hibernateDependency = (EAPModuleDependency)Mockito.mock(EAPBaseModuleDependency.class);
        Mockito.when((Object)drools_hibernateDependency.getName()).thenReturn((Object)"org.hibernate");
        Mockito.when((Object)drools_hibernateDependency.getSlot()).thenReturn((Object)"main");
        ArrayList<EAPModuleDependency> droolsDeps = new ArrayList<EAPModuleDependency>(2);
        droolsDeps.add(drools_jbpmDependency);
        droolsDeps.add(drools_hibernateDependency);
        droolsDeps.add(drools_jbpmDependency);
        EAPModuleDependency jbpm_droolsDependency = (EAPModuleDependency)Mockito.mock(EAPCustomModuleDependency.class);
        Mockito.when((Object)jbpm_droolsDependency.getName()).thenReturn((Object)"org.drools");
        Mockito.when((Object)jbpm_droolsDependency.getSlot()).thenReturn((Object)"1.0");
        EAPModuleDependency jbpm_hibernateDependency = (EAPModuleDependency)Mockito.mock(EAPBaseModuleDependency.class);
        Mockito.when((Object)jbpm_hibernateDependency.getName()).thenReturn((Object)"org.hibernate");
        Mockito.when((Object)jbpm_hibernateDependency.getSlot()).thenReturn((Object)"main");
        ArrayList<EAPModuleDependency> jbpmDeps = new ArrayList<EAPModuleDependency>(2);
        jbpmDeps.add(jbpm_hibernateDependency);
        jbpmDeps.add(jbpm_droolsDependency);
        jbpmDeps.add(jbpm_droolsDependency);
        jbpmDeps.add(jbpm_hibernateDependency);
        Mockito.when((Object)this.droolsModule.getDependencies()).thenReturn(droolsDeps);
        Mockito.when((Object)this.droolsModule.getDependency("org.jbpm:1.0")).thenReturn((Object)drools_jbpmDependency);
        Mockito.when((Object)this.droolsModule.getDependency("org.hibernate:main")).thenReturn((Object)drools_hibernateDependency);
        Mockito.when((Object)this.jbpmModule.getDependencies()).thenReturn(jbpmDeps);
        Mockito.when((Object)this.jbpmModule.getDependency("org.drools:1.0")).thenReturn((Object)jbpm_droolsDependency);
        Mockito.when((Object)this.jbpmModule.getDependency("org.hibernate:main")).thenReturn((Object)jbpm_hibernateDependency);
    }
}

