/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.drools.persistence.infinispan.InfinispanPersistenceContext;
import org.infinispan.Cache;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessEntityHolder;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.internal.process.CorrelationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanProcessPersistenceContext
extends InfinispanPersistenceContext
implements ProcessPersistenceContext {
    private static Logger logger = LoggerFactory.getLogger(InfinispanProcessPersistenceContext.class);
    private static long PROCESSINSTANCEINFO_KEY = 1L;
    private static long CORRELATIONKEYINFO_KEY = 1L;
    private static final Object keyObject = new Object();

    public InfinispanProcessPersistenceContext(Cache<String, Object> cache) {
        super(cache);
    }

    public ProcessInstanceInfo persist(ProcessInstanceInfo processInstanceInfo) {
        String id = this.generateProcessInstanceInfoId(processInstanceInfo);
        this.getCache().put((Object)id, (Object)new ProcessEntityHolder(id, processInstanceInfo));
        return processInstanceInfo;
    }

    public ProcessInstanceInfo findProcessInstanceInfo(Long processInstanceId) {
        String key = this.inferProcessInstanceInfoId(processInstanceId);
        ProcessEntityHolder holder = (ProcessEntityHolder)((Object)this.getCache().get((Object)key));
        if (holder == null) {
            return null;
        }
        return holder.getProcessInstanceInfo();
    }

    public void remove(ProcessInstanceInfo processInstanceInfo) {
        this.getCache().remove((Object)this.generateProcessInstanceInfoId(processInstanceInfo));
        this.getCache().evict((Object)this.generateProcessInstanceInfoId(processInstanceInfo));
        List<CorrelationKeyInfo> correlations = this.getCorrelationKeysByProcessInstanceId(processInstanceInfo.getId());
        if (correlations != null) {
            for (CorrelationKeyInfo key : correlations) {
                this.getCache().remove((Object)this.generateCorrelationKeyInfoId(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateCorrelationKeyInfoId(CorrelationKeyInfo info) {
        if (info != null && info.getId() <= 0L) {
            Object object = keyObject;
            synchronized (object) {
                while (this.getCache().containsKey((Object)("correlationInfo" + CORRELATIONKEYINFO_KEY))) {
                    ++CORRELATIONKEYINFO_KEY;
                }
            }
            try {
                Field idField = CorrelationKeyInfo.class.getDeclaredField("id");
                idField.setAccessible(true);
                idField.set(info, CORRELATIONKEYINFO_KEY);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Unable to set id field of " + CorrelationKeyInfo.class.getSimpleName() + " instance.", e);
            }
        }
        return "correlationInfo" + info.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProcessInstanceInfoId(ProcessInstanceInfo info) {
        if (info != null && (info.getId() == null || info.getId() <= 0L)) {
            Object object = keyObject;
            synchronized (object) {
                while (this.getCache().containsKey((Object)this.inferProcessInstanceInfoId(PROCESSINSTANCEINFO_KEY))) {
                    ++PROCESSINSTANCEINFO_KEY;
                }
            }
            info.setId(Long.valueOf(PROCESSINSTANCEINFO_KEY));
        }
        return this.inferProcessInstanceInfoId(info.getId());
    }

    private String inferProcessInstanceInfoId(Long processInstanceId) {
        return "processInstanceInfo" + processInstanceId;
    }

    private List<CorrelationKeyInfo> getCorrelationKeysByProcessInstanceId(Long pId) {
        Cache cache = this.getCache();
        ArrayList<CorrelationKeyInfo> retval = new ArrayList<CorrelationKeyInfo>();
        for (String key : cache.keySet()) {
            ProcessEntityHolder holder;
            if (!key.startsWith("correlationInfo") || !pId.equals((holder = (ProcessEntityHolder)((Object)cache.get((Object)key))).getProcessInstanceId())) continue;
            retval.add(holder.getCorrelationKeyInfo());
        }
        return retval;
    }

    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        Cache cache = this.getCache();
        ArrayList<Long> retval = new ArrayList<Long>();
        for (String key : cache.keySet()) {
            ProcessEntityHolder holder;
            if (!key.startsWith("processInstanceInfo") || (holder = (ProcessEntityHolder)((Object)cache.get((Object)key))) == null || holder.getProcessInstanceEventTypes() == null || !holder.getProcessInstanceEventTypes().contains(type)) continue;
            retval.add(holder.getProcessInstanceId());
        }
        return retval;
    }

    public CorrelationKeyInfo persist(CorrelationKeyInfo correlationKeyInfo) {
        Long processInstanceId = this.getProcessInstanceByCorrelationKey((CorrelationKey)correlationKeyInfo);
        if (processInstanceId != null) {
            throw new RuntimeException(correlationKeyInfo + " already exists");
        }
        String id = this.generateCorrelationKeyInfoId(correlationKeyInfo);
        this.getCache().put((Object)id, (Object)new ProcessEntityHolder(id, correlationKeyInfo));
        return correlationKeyInfo;
    }

    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        String propertiesString = ProcessEntityHolder.generateString(correlationKey.getProperties());
        Cache cache = this.getCache();
        ArrayList<Long> retval = new ArrayList<Long>();
        for (String key : cache.keySet()) {
            ProcessEntityHolder holder;
            if (!key.startsWith("correlationInfo") || (holder = (ProcessEntityHolder)((Object)cache.get((Object)key))).getCorrelationKeyId() != (long)correlationKey.getProperties().size() || !holder.getCorrelationKeyProperties().contains(propertiesString)) continue;
            retval.add(holder.getProcessInstanceId());
        }
        return retval.size() == 1 ? (Long)retval.iterator().next() : null;
    }
}

