/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.lang.reflect.Field;
import java.util.Collection;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.CreateCorrelatedProcessInstanceCommand;
import org.drools.core.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.InternalExecutable;
import org.drools.core.runtime.InternalLocalRunner;
import org.drools.persistence.PersistableRunner;
import org.jbpm.persistence.api.PersistentProcessInstance;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.api.ProcessPersistenceContextManager;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.process.ProcessInstance;

public class ManualPersistProcessInterceptor
extends AbstractInterceptor {
    private final SingleSessionCommandService interceptedService;

    public ManualPersistProcessInterceptor(SingleSessionCommandService interceptedService) {
        this.interceptedService = interceptedService;
    }

    public RequestContext execute(Executable executable, RequestContext ctx) {
        RuntimeException error = null;
        try {
            this.executeNext(executable, (Context)ctx);
        }
        catch (RuntimeException e) {
            error = e;
        }
        KieSession ksession = this.interceptedService.getKieSession();
        try {
            Field jpmField = PersistableRunner.class.getDeclaredField("jpm");
            jpmField.setAccessible(true);
            Object jpm = jpmField.get(this.interceptedService);
            if (error == null && this.isValidCommand((Command)((Batch)((InternalExecutable)executable).getBatches().get(0)).getCommands().get(0))) {
                this.executeNext((Executable)new InternalLocalRunner.SingleCommandExecutable((Command)new PersistProcessCommand(jpm, ksession)), (Context)ctx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't force persistence of process instance infos", e);
        }
        if (error != null) {
            throw error;
        }
        return ctx;
    }

    protected boolean isValidCommand(Command<?> command) {
        return command instanceof StartProcessCommand || command instanceof CreateProcessInstanceCommand || command instanceof CreateCorrelatedProcessInstanceCommand || command instanceof StartProcessInstanceCommand || command instanceof SignalEventCommand || command instanceof CompleteWorkItemCommand || command instanceof AbortWorkItemCommand || command instanceof AbortProcessInstanceCommand || command instanceof FireAllRulesCommand;
    }

    public SingleSessionCommandService getInterceptedService() {
        return this.interceptedService;
    }

    public static class PersistProcessCommand
    implements ExecutableCommand<Void> {
        private final ProcessPersistenceContext persistenceContext;
        private final KieSession ksession;

        public PersistProcessCommand(Object jpm, KieSession ksession) {
            this.persistenceContext = ((ProcessPersistenceContextManager)jpm).getProcessPersistenceContext();
            this.ksession = ksession;
        }

        public Void execute(Context context) {
            Collection processInstances = this.ksession.getProcessInstances();
            for (Object obj : processInstances) {
                org.jbpm.process.instance.ProcessInstance instance = (org.jbpm.process.instance.ProcessInstance)obj;
                boolean notCompeted = instance.getState() != 2;
                boolean notAborted = instance.getState() != 3;
                boolean hasId = instance.getId() > 0L;
                if (!hasId || !notCompeted || !notAborted) continue;
                ProcessInstanceInfo info = new ProcessInstanceInfo((ProcessInstance)instance, this.ksession.getEnvironment());
                info.setId(Long.valueOf(instance.getId()));
                info.transform();
                this.persistenceContext.persist((PersistentProcessInstance)info);
            }
            return null;
        }
    }
}

