/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg.processor;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpm.process.svg.model.SVGSummary;
import org.jbpm.process.svg.model.Transformation;
import org.jbpm.process.svg.processor.SVGProcessor;
import org.w3c.dom.Document;

public abstract class AbstractSVGProcessor
implements SVGProcessor {
    protected Document svgDocument;
    protected SVGSummary summary = new SVGSummary();
    protected boolean mapById = true;

    public AbstractSVGProcessor(Document svgDocument, boolean mapById) {
        this.svgDocument = svgDocument;
        this.mapById = mapById;
    }

    @Override
    public void transform(Transformation t) {
        t.transform(this.summary);
    }

    @Override
    public String getSVG() {
        try {
            DOMSource domSource = new DOMSource(this.svgDocument.getFirstChild());
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Could not transform svg", e);
        }
    }
}

