/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg.model;

import org.jbpm.process.svg.model.NodeSummary;
import org.jbpm.process.svg.model.NodeTransformation;
import org.jbpm.process.svg.model.SVGSummary;
import org.w3c.dom.Element;

public class SetSubProcessLinkTransformation
extends NodeTransformation {
    private String link;

    public SetSubProcessLinkTransformation(String nodeId, String link) {
        super(nodeId);
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    @Override
    public void transform(SVGSummary summary) {
        NodeSummary node = summary.getNode(this.getNodeId());
        if (node != null) {
            Element linkNode = node.getSubProcessLink();
            if (linkNode != null) {
                linkNode.setAttribute("onclick", "");
                linkNode.setAttribute("xlink:href", this.link);
                linkNode.setAttribute("target", "_blank");
            } else {
                Element plusButton = node.getPlusButton();
                if (plusButton != null) {
                    plusButton.setAttribute("onclick", "window.open('" + this.link + "')");
                    plusButton.setAttribute("style", "cursor: pointer;");
                }
            }
        }
    }
}

