/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.explainability.DecisionExplainabilityResourceExecutor;
import org.kie.kogito.explainability.model.ModelIdentifier;
import org.kie.kogito.explainability.model.PredictInput;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DecisionExplainabilityResourceExecutorTest {
    static Stream<Arguments> getDecisionModelTestProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"namespace", "name"}}), Arguments.of((Object[])new Object[]{new String[]{"myFancyNamespace:/fdss2344-+{}\"", "myFancyName"}}), Arguments.of((Object[])new Object[]{new String[]{"hello::::", "myFancyName"}}), Arguments.of((Object[])new Object[]{new String[]{"hello()", "myFanc+_-_234';yName"}}));
    }

    @ParameterizedTest
    @MethodSource(value={"getDecisionModelTestProvider"})
    public void testGetDecisionModel(String[] args) {
        String namespace = args[0];
        String name = args[1];
        DecisionExplainabilityResourceExecutor executor = new DecisionExplainabilityResourceExecutor();
        DecisionModels decisionModels = (DecisionModels)Mockito.mock(DecisionModels.class);
        DmnDecisionModel model = new DmnDecisionModel(this.generateDMNRuntime(namespace, name), namespace, name);
        Mockito.when((Object)decisionModels.getDecisionModel((String)ArgumentMatchers.eq((Object)namespace), (String)ArgumentMatchers.eq((Object)name))).thenReturn((Object)model);
        ModelIdentifier modelIdentifier = new ModelIdentifier("dmn", String.format("%s%s%s", namespace, ":", name));
        DecisionModel decisionModelResponse = executor.getDecisionModel(decisionModels, modelIdentifier);
        Assertions.assertThat((Object)decisionModelResponse).isNotNull();
        Assertions.assertThat((String)decisionModelResponse.getDMNModel().getNamespace()).isEqualTo(namespace);
        Assertions.assertThat((String)decisionModelResponse.getDMNModel().getName()).isEqualTo(name);
    }

    @Test
    public void testAcceptRequest() {
        DecisionExplainabilityResourceExecutor executor = new DecisionExplainabilityResourceExecutor();
        ModelIdentifier notADMNModelIdentifier = new ModelIdentifier("notAdmn", String.format("%s%s%s", "namespace", ":", "name"));
        ModelIdentifier DMNModelIdentifier = new ModelIdentifier("dmn", String.format("%s%s%s", "namespace", ":", "name"));
        PredictInput notADMNModelPredictInput = new PredictInput(notADMNModelIdentifier, null);
        PredictInput DMNModelPredictInput = new PredictInput(DMNModelIdentifier, null);
        Assertions.assertThat((boolean)executor.acceptRequest(notADMNModelPredictInput)).isFalse();
        Assertions.assertThat((boolean)executor.acceptRequest(DMNModelPredictInput)).isTrue();
    }

    private DMNRuntime generateDMNRuntime(String namespace, String name) {
        DMNRuntime runtime = (DMNRuntime)Mockito.mock(DMNRuntime.class);
        DMNModel dmnModel = (DMNModel)Mockito.mock(DMNModel.class);
        Mockito.when((Object)dmnModel.getNamespace()).thenReturn((Object)namespace);
        Mockito.when((Object)dmnModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)runtime.getModel((String)ArgumentMatchers.eq((Object)namespace), (String)ArgumentMatchers.eq((Object)name))).thenReturn((Object)dmnModel);
        return runtime;
    }
}

