/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.client.MongoClient;
import org.kie.kogito.internal.process.runtime.HeadersPersistentConfig;
import org.kie.kogito.mongodb.MongoDBProcessInstances;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstancesFactory;

public abstract class AbstractProcessInstancesFactory
implements ProcessInstancesFactory {
    private final MongoClient mongoClient;
    private final String dbName;
    private final Boolean lock;
    private final AbstractTransactionManager transactionManager;
    private HeadersPersistentConfig headersConfig;

    public AbstractProcessInstancesFactory(MongoClient mongoClient, String dbName, Boolean lock, AbstractTransactionManager transactionManager) {
        this(mongoClient, dbName, lock, transactionManager, null);
    }

    public AbstractProcessInstancesFactory(MongoClient mongoClient, String dbName, Boolean lock, AbstractTransactionManager transactionManager, HeadersPersistentConfig headersPersistentConfig) {
        this.mongoClient = mongoClient;
        this.dbName = dbName;
        this.lock = lock;
        this.transactionManager = transactionManager;
        this.headersConfig = headersPersistentConfig;
    }

    public MongoDBProcessInstances<?> createProcessInstances(Process<?> process) {
        return new MongoDBProcessInstances(this.mongoClient, process, this.dbName, this.transactionManager, this.lock, this.headersConfig);
    }
}

