/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.UpdateResult;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.jbpm.flow.serialization.MarshallerContextName;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerService;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.runtime.HeadersPersistentConfig;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;

public class MongoDBProcessInstances<T extends Model>
implements MutableProcessInstances<T> {
    private static final String VERSION = "version";
    private Process<?> process;
    private ProcessInstanceMarshallerService marshaller;
    private final MongoCollection<Document> collection;
    private final AbstractTransactionManager transactionManager;
    private final boolean lock;

    public MongoDBProcessInstances(MongoClient mongoClient, Process<?> process, String dbName, AbstractTransactionManager transactionManager, boolean lock) {
        this(mongoClient, process, dbName, transactionManager, lock, null);
    }

    public MongoDBProcessInstances(MongoClient mongoClient, Process<?> process, String dbName, AbstractTransactionManager transactionManager, boolean lock, HeadersPersistentConfig headersConfig) {
        this.process = process;
        this.collection = Objects.requireNonNull(this.getCollection(mongoClient, process.id(), dbName));
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().withDefaultListeners().withContextEntry(MarshallerContextName.MARSHALLER_FORMAT, (Object)"json").withContextEntry(MarshallerContextName.MARSHALLER_HEADERS_CONFIG, (Object)headersConfig).build();
        this.transactionManager = Objects.requireNonNull(transactionManager);
        this.lock = lock;
    }

    public Optional<ProcessInstance<T>> findById(String id, ProcessInstanceReadMode mode) {
        return this.find(id).map(piDoc -> {
            AbstractProcessInstance pi = (AbstractProcessInstance)this.unmarshall((Document)piDoc, mode);
            if (!ProcessInstanceReadMode.READ_ONLY.equals((Object)mode)) {
                this.reloadProcessInstance((ProcessInstance<T>)pi, id);
            }
            return pi;
        });
    }

    public Stream<ProcessInstance<T>> stream(ProcessInstanceReadMode mode) {
        ClientSession clientSession = this.transactionManager.getClientSession();
        MongoCursor docs = (clientSession == null ? this.collection.find() : this.collection.find(clientSession)).iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(docs, 16), false).map(doc -> this.unmarshall((Document)doc, mode)).onClose(() -> ((MongoCursor)docs).close());
    }

    private ProcessInstance<T> unmarshall(Document document, ProcessInstanceReadMode mode) {
        ProcessInstance instance = this.marshaller.unmarshallProcessInstance(document.toJson().getBytes(), this.process, mode);
        MongoDBProcessInstances.setVersion(instance, document.getLong((Object)VERSION));
        return instance;
    }

    public void create(String id, ProcessInstance<T> instance) {
        this.updateStorage(id, instance, true);
    }

    public void update(String id, ProcessInstance<T> instance) {
        if (this.isActive(instance)) {
            this.updateStorage(id, instance, false);
        }
        this.reloadProcessInstance(instance, id);
    }

    protected void updateStorage(String id, ProcessInstance<T> instance, boolean checkDuplicates) {
        ClientSession clientSession = this.transactionManager.getClientSession();
        Document doc = Document.parse((String)new String(this.marshaller.marshallProcessInstance(instance)));
        if (checkDuplicates) {
            this.createInternal(id, clientSession, doc);
        } else {
            this.updateInternal(id, instance, clientSession, doc);
        }
    }

    private void createInternal(String id, ClientSession clientSession, Document doc) {
        if (this.exists(id)) {
            throw new ProcessInstanceDuplicatedException(id);
        }
        doc.put(VERSION, (Object)0L);
        if (clientSession != null) {
            this.collection.insertOne(clientSession, (Object)doc);
        } else {
            this.collection.insertOne((Object)doc);
        }
    }

    private void updateInternal(String id, ProcessInstance<T> instance, ClientSession clientSession, Document doc) {
        Bson filters = Filters.eq((String)"id", (Object)id);
        if (this.lock) {
            doc.put(VERSION, (Object)(instance.version() + 1L));
            filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"id", (Object)id), Filters.eq((String)VERSION, (Object)instance.version())});
        }
        UpdateResult result = clientSession != null ? this.collection.replaceOne(clientSession, filters, (Object)doc) : this.collection.replaceOne(filters, (Object)doc);
        if (this.lock && result.getModifiedCount() != 1L) {
            throw new ProcessInstanceOptimisticLockingException(id);
        }
    }

    private Optional<Document> find(String id) {
        ClientSession clientSession = this.transactionManager.getClientSession();
        return Optional.ofNullable((Document)(clientSession != null ? this.collection.find(clientSession, Filters.eq((String)"id", (Object)id)) : this.collection.find(Filters.eq((String)"id", (Object)id))).first());
    }

    public boolean exists(String id) {
        return this.find(id).isPresent();
    }

    public void remove(String id) {
        ClientSession clientSession = this.transactionManager.getClientSession();
        if (clientSession != null) {
            this.collection.deleteOne(clientSession, Filters.eq((String)"id", (Object)id));
        } else {
            this.collection.deleteOne(Filters.eq((String)"id", (Object)id));
        }
    }

    private void reloadProcessInstance(ProcessInstance<T> instance, String id) {
        ((AbstractProcessInstance)instance).internalSetReloadSupplier(this.marshaller.createdReloadFunction(() -> this.find(id).map(reloaded -> {
            MongoDBProcessInstances.setVersion(instance, reloaded.getLong((Object)VERSION));
            return reloaded.toJson().getBytes();
        }).orElseThrow(() -> new IllegalArgumentException("process instance id " + id + " does not exists in mongodb"))));
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance();
    }

    private static void setVersion(ProcessInstance<?> instance, Long version) {
        ((AbstractProcessInstance)instance).setVersion(version == null ? 0L : version);
    }

    public boolean lock() {
        return this.lock;
    }

    protected MongoCollection<Document> getCollection() {
        return this.collection;
    }

    private MongoCollection<Document> getCollection(MongoClient mongoClient, String processId, String dbName) {
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry()});
        MongoDatabase mongoDatabase = mongoClient.getDatabase(dbName).withCodecRegistry(registry);
        MongoCollection collection = mongoDatabase.getCollection(processId, Document.class).withCodecRegistry(registry);
        collection.createIndex(Indexes.ascending((String[])new String[]{"id"}), new IndexOptions().unique(true).name("index_process_instance_id").background(true));
        return collection;
    }
}

