/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb.correlation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.InsertOneResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.SimpleCorrelation;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class MongoDBCorrelationRepository {
    private final MongoCollection<Document> collection;
    private final ObjectMapper objectMapper;
    private static final String ENCODED_CORRELATION_ID_FIELD = "encodedCorrelationId";
    private static final String CORRELATED_ID_FIELD = "correlatedId";
    private static final String CORRELATION_FIELD = "correlation";
    private static final String CORRELATION_COLLECTION_NAME = "correlations";

    public MongoDBCorrelationRepository(MongoClient mongoClient, String dbName) {
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry()});
        this.collection = mongoClient.getDatabase(dbName).getCollection(CORRELATION_COLLECTION_NAME).withCodecRegistry(registry);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addAbstractTypeMapping(Correlation.class, SimpleCorrelation.class);
        this.objectMapper = ObjectMapperFactory.get().copy().registerModule((Module)simpleModule);
    }

    public CorrelationInstance insert(String encodedCorrelationId, String correlatedId, Correlation correlation) {
        CorrelationInstance correlationInstance = new CorrelationInstance(encodedCorrelationId, correlatedId, correlation);
        try {
            Map<String, Correlation> object = Map.of(ENCODED_CORRELATION_ID_FIELD, encodedCorrelationId, CORRELATED_ID_FIELD, correlatedId, CORRELATION_FIELD, correlation);
            String json = this.objectMapper.writeValueAsString(object);
            InsertOneResult insertOneResult = this.collection.insertOne((Object)Document.parse((String)json));
            return insertOneResult.getInsertedId() != null ? correlationInstance : null;
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public CorrelationInstance findByEncodedCorrelationId(String encoded) {
        Bson eq = Filters.eq((String)ENCODED_CORRELATION_ID_FIELD, (Object)encoded);
        return this.getCorrelationInstanceByFilter(eq);
    }

    public CorrelationInstance findByCorrelatedId(String correlatedId) {
        Bson eq = Filters.eq((String)CORRELATED_ID_FIELD, (Object)correlatedId);
        return this.getCorrelationInstanceByFilter(eq);
    }

    private CorrelationInstance getCorrelationInstanceByFilter(Bson eq) {
        Document first = (Document)this.collection.find(eq).first();
        if (first == null) {
            return null;
        }
        Document document = (Document)first.get((Object)CORRELATION_FIELD, Document.class);
        try {
            CompositeCorrelation compositeCorrelation = (CompositeCorrelation)this.objectMapper.readValue(document.toJson(), CompositeCorrelation.class);
            return new CorrelationInstance(first.getString((Object)ENCODED_CORRELATION_ID_FIELD), first.getString((Object)CORRELATED_ID_FIELD), (Correlation)compositeCorrelation);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void delete(String encoded) {
        Bson eq = Filters.eq((String)ENCODED_CORRELATION_ID_FIELD, (Object)encoded);
        this.collection.deleteOne(eq);
    }
}

