/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb.correlation;

import java.util.Optional;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationEncoder;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.CorrelationService;
import org.kie.kogito.event.correlation.MD5CorrelationEncoder;
import org.kie.kogito.mongodb.correlation.MongoDBCorrelationRepository;

public class MongoDBCorrelationService
implements CorrelationService {
    private final MongoDBCorrelationRepository correlationRepository;
    private final CorrelationEncoder correlationEncoder;

    public MongoDBCorrelationService(MongoDBCorrelationRepository correlationRepository) {
        this.correlationRepository = correlationRepository;
        this.correlationEncoder = new MD5CorrelationEncoder();
    }

    public CorrelationInstance create(Correlation correlation, String correlatedId) {
        String encodedCorrelationId = this.correlationEncoder.encode(correlation);
        return this.correlationRepository.insert(encodedCorrelationId, correlatedId, correlation);
    }

    public Optional<CorrelationInstance> find(Correlation correlation) {
        String encodedCorrelationId = this.correlationEncoder.encode(correlation);
        return Optional.ofNullable(this.correlationRepository.findByEncodedCorrelationId(encodedCorrelationId));
    }

    public Optional<CorrelationInstance> findByCorrelatedId(String correlatedId) {
        return Optional.ofNullable(this.correlationRepository.findByCorrelatedId(correlatedId));
    }

    public void delete(Correlation correlation) {
        String encodedCorrelationId = this.correlationEncoder.encode(correlation);
        this.correlationRepository.delete(encodedCorrelationId);
    }
}

