/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.dynamic;

import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.stream.Collectors;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.dynamic.ProcessInstanceDynamicCallHelper;
import org.kie.kogito.process.dynamic.RestCallInfo;
import org.kogito.workitem.rest.RestWorkItemHandler;

@Path(value="/_dynamic")
public class ProcessInstanceDynamicCallsResource {
    @Inject
    Vertx vertx;
    @Inject
    WebClientOptions sslOptions;
    private RestWorkItemHandler handler;
    private Collection<Process<?>> processes;

    @Inject
    ProcessInstanceDynamicCallsResource(Instance<Process<?>> processes) {
        this.processes = processes.stream().collect(Collectors.toUnmodifiableList());
    }

    @PostConstruct
    void init() {
        this.handler = new RestWorkItemHandler(WebClient.create((Vertx)this.vertx), WebClient.create((Vertx)this.vertx, (WebClientOptions)this.sslOptions));
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{processId}/{processInstanceId}/rest")
    public Response executeRestCall(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, RestCallInfo input) {
        ProcessInstanceDynamicCallHelper.executeRestCall((RestWorkItemHandler)this.handler, this.processes, (String)processId, (String)processInstanceId, (RestCallInfo)input);
        return Response.status((int)200).build();
    }
}

