/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resource.exceptions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.kogito.handler.ExceptionHandler;
import org.kie.kogito.internal.process.runtime.MessageException;
import org.kie.kogito.internal.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.internal.process.workitem.InvalidTransitionException;
import org.kie.kogito.internal.process.workitem.NotAuthorizedException;
import org.kie.kogito.internal.process.workitem.WorkItemExecutionException;
import org.kie.kogito.internal.process.workitem.WorkItemNotFoundException;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.resource.exceptions.ExceptionBodyMessage;
import org.kie.kogito.resource.exceptions.ExceptionBodyMessageFunctions;
import org.kie.kogito.resource.exceptions.RestExceptionHandler;
import org.kie.kogito.usertask.UserTaskInstanceNotAuthorizedException;
import org.kie.kogito.usertask.UserTaskInstanceNotFoundException;
import org.kie.kogito.usertask.lifecycle.UserTaskTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionsHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExceptionsHandler.class);
    RestExceptionHandler<? extends Exception, T> DEFAULT_HANDLER = RestExceptionHandler.newExceptionHandler(Exception.class, this::badRequest);
    private Map<Class<? extends Throwable>, RestExceptionHandler<? extends Throwable, T>> mapper;
    private List<ExceptionHandler> errorHandlers;

    protected AbstractExceptionsHandler() {
        this(Collections.emptyList());
    }

    protected AbstractExceptionsHandler(Iterable<ExceptionHandler> errorHandlers) {
        List<RestExceptionHandler> handlers = List.of(RestExceptionHandler.newExceptionHandler(InvalidLifeCyclePhaseException.class, this::badRequest), RestExceptionHandler.newExceptionHandler(UserTaskTransitionException.class, this::badRequest), RestExceptionHandler.newExceptionHandler(UserTaskInstanceNotFoundException.class, this::notFound), RestExceptionHandler.newExceptionHandler(UserTaskInstanceNotAuthorizedException.class, this::forbidden), RestExceptionHandler.newExceptionHandler(InvalidTransitionException.class, this::badRequest), RestExceptionHandler.newExceptionHandler(NodeInstanceNotFoundException.class, ExceptionBodyMessageFunctions.nodeInstanceNotFoundMessageException(), this::notFound), RestExceptionHandler.newExceptionHandler(NodeNotFoundException.class, ExceptionBodyMessageFunctions.nodeNotFoundMessageException(), this::notFound), RestExceptionHandler.newExceptionHandler(NotAuthorizedException.class, this::forbidden), RestExceptionHandler.newExceptionHandler(ProcessInstanceDuplicatedException.class, ExceptionBodyMessageFunctions.processInstanceDuplicatedMessageException(), this::conflict), RestExceptionHandler.newExceptionHandler(ProcessInstanceExecutionException.class, ExceptionBodyMessageFunctions.processInstanceExecutionMessageException(), this::internalError), RestExceptionHandler.newExceptionHandler(ProcessInstanceNotFoundException.class, ExceptionBodyMessageFunctions.processInstanceNotFoundExceptionMessageException(), this::notFound), RestExceptionHandler.newExceptionHandler(WorkItemNotFoundException.class, ExceptionBodyMessageFunctions.workItemNotFoundMessageException(), this::notFound), RestExceptionHandler.newExceptionHandler(VariableViolationException.class, ExceptionBodyMessageFunctions.variableViolationMessageException(), this::badRequest), RestExceptionHandler.newExceptionHandler(WorkItemExecutionException.class, ExceptionBodyMessageFunctions.workItemExecutionMessageException(), this::fromErrorCode), RestExceptionHandler.newExceptionHandler(IllegalArgumentException.class, this::badRequest), RestExceptionHandler.newExceptionHandler(MessageException.class, this::badRequest));
        this.mapper = new HashMap<Class<? extends Throwable>, RestExceptionHandler<? extends Throwable, T>>();
        for (RestExceptionHandler handler : handlers) {
            this.mapper.put(handler.getType(), handler);
        }
        this.errorHandlers = new ArrayList<ExceptionHandler>();
        errorHandlers.iterator().forEachRemaining(this.errorHandlers::add);
    }

    private T fromErrorCode(ExceptionBodyMessage message) {
        switch (message.getErrorCode()) {
            case "400": {
                return this.badRequest(message);
            }
            case "403": {
                return this.forbidden(message);
            }
            case "404": {
                return this.notFound(message);
            }
            case "409": {
                return this.conflict(message);
            }
        }
        return this.internalError(message);
    }

    protected abstract T badRequest(ExceptionBodyMessage var1);

    protected abstract T conflict(ExceptionBodyMessage var1);

    protected abstract T internalError(ExceptionBodyMessage var1);

    protected abstract T notFound(ExceptionBodyMessage var1);

    protected abstract T forbidden(ExceptionBodyMessage var1);

    public T mapException(Exception exceptionThrown) {
        RestExceptionHandler<Throwable, T> handler = this.mapper.getOrDefault(exceptionThrown.getClass(), this.DEFAULT_HANDLER);
        ExceptionBodyMessage message = handler.getContent(exceptionThrown);
        for (Throwable rootCause = exceptionThrown.getCause(); rootCause != null; rootCause = rootCause.getCause()) {
            if (!this.mapper.containsKey(rootCause.getClass())) continue;
            handler = this.mapper.get(rootCause.getClass());
            message.merge(handler.getContent(rootCause));
        }
        this.errorHandlers.forEach(e -> e.handle(exceptionThrown));
        T response = handler.buildResponse(message);
        LOG.debug("mapping exception {} with response {}", (Object)exceptionThrown, message.getBody());
        return response;
    }
}

