/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resource.exceptions;

import java.util.function.Function;
import org.kie.kogito.resource.exceptions.ExceptionBodyMessage;
import org.kie.kogito.resource.exceptions.ExceptionBodyMessageFunctions;

public class RestExceptionHandler<EXCEPTION extends Throwable, RESPONSE> {
    private final Function<EXCEPTION, ExceptionBodyMessage> messageConverter;
    private final Function<ExceptionBodyMessage, RESPONSE> responseConverter;
    private Class<EXCEPTION> type;

    public RestExceptionHandler(Class<EXCEPTION> type, Function<EXCEPTION, ExceptionBodyMessage> messageConverter, Function<ExceptionBodyMessage, RESPONSE> responseConverter) {
        this.type = type;
        this.messageConverter = messageConverter;
        this.responseConverter = responseConverter;
    }

    public Class<EXCEPTION> getType() {
        return this.type;
    }

    public ExceptionBodyMessage getContent(Throwable exception) {
        return this.messageConverter.apply((Throwable)this.getType().cast(exception));
    }

    public RESPONSE buildResponse(ExceptionBodyMessage exceptionBodyMessage) {
        return this.responseConverter.apply(exceptionBodyMessage);
    }

    public static <TYPE extends Exception, RES> RestExceptionHandler<TYPE, RES> newExceptionHandler(Class<TYPE> type, Function<TYPE, ExceptionBodyMessage> contentGenerator, Function<ExceptionBodyMessage, RES> responseGenerator) {
        return new RestExceptionHandler<TYPE, RES>(type, contentGenerator, responseGenerator);
    }

    public static <F extends Exception, R> RestExceptionHandler<F, R> newExceptionHandler(Class<F> type, Function<ExceptionBodyMessage, R> responseGenerator) {
        return new RestExceptionHandler<F, R>(type, ExceptionBodyMessageFunctions.defaultMessageException(), responseGenerator);
    }
}

