/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.auth;

import java.util.List;
import java.util.Optional;
import org.kie.kogito.svg.auth.PrincipalAuthTokenReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={SecurityContextHolder.class})
public class SpringBootAuthHelper {
    private List<PrincipalAuthTokenReader> authTokenReaders;

    public SpringBootAuthHelper(@Autowired List<PrincipalAuthTokenReader> authTokenReaders) {
        this.authTokenReaders = authTokenReaders;
    }

    public Optional<String> getAuthToken() {
        return Optional.ofNullable(this.getToken());
    }

    private String getToken() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null || securityContext.getAuthentication() == null) {
            return null;
        }
        Object principal = securityContext.getAuthentication().getPrincipal();
        return this.authTokenReaders.stream().filter(reader -> reader.acceptsPrincipal(principal)).findFirst().map(reader -> "Bearer " + reader.readToken(principal)).orElse(null);
    }
}

