/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.dataindex;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.auth.SpringBootAuthHelper;
import org.kie.kogito.svg.dataindex.DataIndexClient;
import org.kie.kogito.svg.dataindex.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringBootDataIndexClient
implements DataIndexClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootDataIndexClient.class);
    private String dataIndexHttpURL;
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;
    private Optional<SpringBootAuthHelper> authHelper;

    @Autowired
    public SpringBootDataIndexClient(@Value(value="${kogito.dataindex.http.url:http://localhost:8180}") String dataIndexHttpURL, @Autowired(required=false) RestTemplate restTemplate, @Autowired ObjectMapper objectMapper, @Autowired Optional<SpringBootAuthHelper> authHelper) {
        this.dataIndexHttpURL = dataIndexHttpURL;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.authHelper = authHelper;
    }

    @PostConstruct
    public void initialize() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            LOGGER.debug("No RestTemplate found, creating a default one");
        }
    }

    public List<NodeInstance> getNodeInstancesFromProcessInstance(String processInstanceId, String authHeader) {
        String query = this.getNodeInstancesQuery(processInstanceId);
        try {
            String requestJson = this.objectMapper.writeValueAsString(Collections.singletonMap("query", query));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Authorization", this.getAuthHeader(authHeader));
            HttpEntity request = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.postForEntity(this.dataIndexHttpURL + "/graphql", (Object)request, String.class, new Object[0]);
            if (result.getStatusCode().value() == 200) {
                return this.getNodeInstancesFromResponse(this.objectMapper.readTree((String)result.getBody()));
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new ProcessSVGException("Exception while trying to get data from Data Index service", (Throwable)e);
        }
    }

    protected List<NodeInstance> getNodeInstancesFromResponse(JsonNode response) {
        JsonNode pInstancesArray = response.path("data").path("ProcessInstances");
        if (pInstancesArray != null && !pInstancesArray.isEmpty()) {
            ArrayList<NodeInstance> nodes = new ArrayList<NodeInstance>();
            pInstancesArray.get(0).path("nodes").forEach(node -> nodes.add(new NodeInstance(Boolean.valueOf(!node.path("exit").isNull()), node.path("definitionId").asText())));
            return nodes;
        }
        return Collections.emptyList();
    }

    protected String getAuthHeader(String authHeader) {
        if (this.authHelper.isPresent()) {
            return this.authHelper.get().getAuthToken().orElse(authHeader);
        }
        return authHeader;
    }
}

