/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.rest;

import java.util.Optional;
import org.kie.kogito.svg.ProcessSvgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/svg"})
public class SpringBootProcessSvgResource {
    @Autowired
    ProcessSvgService service;

    @GetMapping(value={"processes/{processId}"}, produces={"image/svg+xml"})
    public ResponseEntity getProcessSvg(@PathVariable(value="processId") String processId) {
        Optional processSvg = this.service.getProcessSvg(processId);
        if (processSvg.isPresent()) {
            return ResponseEntity.ok((Object)((String)processSvg.get()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Process with id " + processId + " not found"));
    }

    @GetMapping(value={"processes/{processId}/instances/{processInstanceId}"}, produces={"image/svg+xml"})
    public ResponseEntity getExecutionPathByProcessInstanceId(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @RequestHeader(value="Authorization", required=false) String authHeader) {
        Optional processInstanceSvg = this.service.getProcessInstanceSvg(processId, processInstanceId, authHeader);
        if (processInstanceSvg.isPresent()) {
            return ResponseEntity.ok((Object)((String)processInstanceSvg.get()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("Process with id " + processId + " not found"));
    }

    @Autowired
    protected void setProcessSvgService(ProcessSvgService service) {
        this.service = service;
    }
}

