/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.event.trace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.event.TracingTestUtils;
import org.kie.kogito.tracing.event.message.models.DecisionMessageTest;
import org.kie.kogito.tracing.event.trace.TraceEvent;
import org.kie.kogito.tracing.event.trace.TraceEventType;
import org.kie.kogito.tracing.event.trace.TraceExecutionStep;
import org.kie.kogito.tracing.event.trace.TraceExecutionStepType;
import org.kie.kogito.tracing.event.trace.TraceHeader;
import org.kie.kogito.tracing.event.trace.TraceInputValue;
import org.kie.kogito.tracing.event.trace.TraceOutputValue;
import org.kie.kogito.tracing.event.trace.TraceResourceId;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

class TraceEventTest {
    TraceEventTest() {
    }

    @Test
    public void testDeserialization() throws JsonProcessingException {
        String toRead = TracingTestUtils.readResourceAsString("/traceevent.json");
        TraceEvent retrieved = (TraceEvent)new ObjectMapper().readValue(toRead, TraceEvent.class);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    @Test
    public void testSerialization() throws JsonProcessingException {
        TraceEvent traceEvent = this.getTraceEvent();
        String retrieved = new ObjectMapper().writeValueAsString((Object)traceEvent);
        Assertions.assertThat((String)retrieved).isNotNull();
    }

    private TraceEvent getTraceEvent() {
        TraceHeader header = this.getTraceHeader(new Random().nextInt(10));
        List inputs = IntStream.range(0, 3).mapToObj(this::getTraceInputValue).collect(Collectors.toList());
        List outputs = IntStream.range(0, 3).mapToObj(this::getTraceOutputValue).collect(Collectors.toList());
        List executionSteps = IntStream.range(0, 3).mapToObj(this::getTraceExecutionStep).collect(Collectors.toList());
        return new TraceEvent(header, inputs, outputs, executionSteps);
    }

    private TraceExecutionStep getTraceExecutionStep(int id) {
        List messages = IntStream.range(id + 1, id + 3).mapToObj(DecisionMessageTest::getDecisionMessage).collect(Collectors.toList());
        Map<String, String> additionalData = Collections.singletonMap("key", "value");
        List children = IntStream.range(id + 1, id + 3).mapToObj(i -> this.getTraceExecutionStep()).collect(Collectors.toList());
        return new TraceExecutionStep(this.getTraceExecutionStepType(), new Random().nextLong(), "name-" + id, (JsonNode)new IntNode(id), messages, additionalData, children);
    }

    private TraceExecutionStep getTraceExecutionStep() {
        List messages = IntStream.range(0, 3).mapToObj(DecisionMessageTest::getDecisionMessage).collect(Collectors.toList());
        Map<String, String> additionalData = Collections.singletonMap("c-key", "c-value");
        return new TraceExecutionStep(this.getTraceExecutionStepType(), new Random().nextLong(), "children-name", (JsonNode)BooleanNode.getFalse(), messages, additionalData, Collections.emptyList());
    }

    private TraceExecutionStepType getTraceExecutionStepType() {
        return TraceExecutionStepType.values()[new Random().nextInt(TraceExecutionStepType.values().length)];
    }

    private TraceHeader getTraceHeader(int id) {
        Long startTimestamp = System.currentTimeMillis();
        Long duration = new Random().nextInt(10000000);
        Long endTimestamp = startTimestamp + duration;
        List messages = IntStream.range(id + 1, id + 3).mapToObj(DecisionMessageTest::getDecisionMessage).collect(Collectors.toList());
        return new TraceHeader(TraceEventType.DMN, "execution-" + id, startTimestamp, endTimestamp, duration, this.getTraceResourceId(id), messages);
    }

    private TraceResourceId getTraceResourceId(int id) {
        return new TraceResourceId("serviceUrl-" + id, "modelNamespace-" + id, "modelName-" + id);
    }

    private TraceInputValue getTraceInputValue(int id) {
        String valueType = "type-" + id;
        UnitValue value = new UnitValue(valueType);
        List messages = IntStream.range(id + 1, id + 3).mapToObj(DecisionMessageTest::getDecisionMessage).collect(Collectors.toList());
        return new TraceInputValue("id-" + id, "name-" + id, (TypedValue)value, messages);
    }

    private TraceOutputValue getTraceOutputValue(int id) {
        String valueType = "type-" + id;
        UnitValue value = new UnitValue(valueType);
        Map<CallSite, UnitValue> inputs = Collections.singletonMap(valueType, value);
        List messages = IntStream.range(id + 1, id + 3).mapToObj(DecisionMessageTest::getDecisionMessage).collect(Collectors.toList());
        return new TraceOutputValue("id-" + id, "name-" + id, "status-" + id, (TypedValue)value, inputs, messages);
    }
}

