/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.event.model.models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.tracing.event.TracingTestUtils;
import org.kie.kogito.tracing.event.model.ModelEvent;
import org.kie.kogito.tracing.event.model.models.DecisionModelEvent;

class DecisionModelEventTest {
    DecisionModelEventTest() {
    }

    @Test
    public void testDeserialization() throws JsonProcessingException {
        String toRead = TracingTestUtils.readResourceAsString("/decisionmodelevent.json");
        ModelEvent retrieved = (ModelEvent)new ObjectMapper().readValue(toRead, ModelEvent.class);
        Assertions.assertThat((Object)retrieved).isInstanceOf(DecisionModelEvent.class);
    }

    @Test
    public void testSerialization() throws JsonProcessingException {
        ModelEvent modelEvent = this.getDecisionModelEvent(new Random().nextInt(5));
        String retrieved = new ObjectMapper().writeValueAsString((Object)modelEvent);
        Assertions.assertThat((String)retrieved).isNotNull();
    }

    private ModelEvent getDecisionModelEvent(int id) {
        return new DecisionModelEvent(this.getKogitoGAV(), "name-" + id, "namespace-" + id, this.getDecisionModelMetadata(id), "definition-" + id);
    }

    private KogitoGAV getKogitoGAV() {
        return new KogitoGAV("groupId", "artifactId", "version");
    }

    private DecisionModelMetadata getDecisionModelMetadata(int id) {
        return new DecisionModelMetadata("specVersion-" + id);
    }
}

