/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.kie.aries.blueprint.namespace.AbstractElementParser;
import org.kie.aries.blueprint.namespace.KieBaseElementParser;
import org.kie.aries.blueprint.namespace.KieContainerElementParser;
import org.kie.aries.blueprint.namespace.KieEnvironmentElementParser;
import org.kie.aries.blueprint.namespace.KieEventListenersElementParser;
import org.kie.aries.blueprint.namespace.KieModuleElementParser;
import org.kie.aries.blueprint.namespace.KieObjectsInjector;
import org.kie.aries.blueprint.namespace.KieRuntimeManagerElementParser;
import org.kie.aries.blueprint.namespace.KieRuntimeManagerSessionElementParser;
import org.kie.aries.blueprint.namespace.KieSessionElementParser;
import org.kie.aries.blueprint.namespace.KieStoreElementParser;
import org.kie.aries.blueprint.namespace.ReleaseIdElementParser;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KieNamespaceHandler
implements NamespaceHandler {
    protected List<URL> resources;
    public static final String NS_URI = "http://drools.org/schema/kie-aries-blueprint/1.0.0";
    private static final String BLUEPRINT_NS = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String ELEMENT_RELEASE_ID = "releaseId";
    public static final String ELEMENT_KBASE_REF = "kbase-ref";
    public static final String ELEMENT_KBASE = "kbase";
    public static final String ELEMENT_KCONTAINER = "kcontainer-ref";
    public static final String ELEMENT_KSTORE = "kstore";
    public static final String ELEMENT_KSESSION = "ksession";
    public static final String ELEMENT_KSESSION_REF = "ksession-ref";
    public static final String ELEMENT_EVENT_LISTENERS = "eventListeners";
    public static final String ELEMENT_ENVIRONMENT = "environment";
    public static final String ELEMENT_KRUNTIMEMANAGER = "kruntimeManager";
    public static final String ELEMENT_KSESSION_RUNTIMEMANAGER = "kruntimeManagerSession";
    public static final String ELEMENT_KMODULE = "kmodule";
    protected static Map<String, AbstractElementParser> droolsElementParserMap = new HashMap<String, AbstractElementParser>();

    public KieNamespaceHandler() {
    }

    public KieNamespaceHandler(List<URL> resources) {
        this.resources = resources;
    }

    public URL getSchemaLocation(String namespace) {
        if (NS_URI.equals(namespace)) {
            return this.getClass().getResource("kie-aries-blueprint.xsd");
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public Metadata parse(Element element, ParserContext parserContext) {
        String elementName = element.getLocalName();
        AbstractElementParser elementParser = droolsElementParserMap.get(elementName);
        if (elementParser == null) {
            throw new ComponentDefinitionException("Unsupported Kie Blueprint Element '" + elementName + "'");
        }
        if (ELEMENT_KMODULE.equalsIgnoreCase(elementName)) {
            this.addKieObjectsProcessor(element, parserContext, elementParser);
        }
        return elementParser.parseElement(parserContext, element);
    }

    private void addKieObjectsProcessor(Element element, ParserContext context, AbstractElementParser elementParser) {
        MutablePassThroughMetadata beanProcessorFactory = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        String id = elementParser.getId(context, element);
        String contextId = ".kie.processor." + id;
        beanProcessorFactory.setId(contextId);
        KieObjectsInjector kieObjectsInjector = new KieObjectsInjector(id, context);
        beanProcessorFactory.setObject(new PassThroughCallable<KieObjectsInjector>(kieObjectsInjector));
        MutableBeanMetadata beanProcessor = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        beanProcessor.setId(".droolsBlueprint.processor.bean." + id);
        beanProcessor.setRuntimeClass(KieObjectsInjector.class);
        beanProcessor.setFactoryComponent((Target)beanProcessorFactory);
        beanProcessor.setFactoryMethod("call");
        beanProcessor.setProcessor(true);
        beanProcessor.setInitMethod("afterPropertiesSet");
        beanProcessor.addProperty("blueprintContainer", (Metadata)AbstractElementParser.createRef(context, "blueprintContainer"));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)beanProcessor);
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        System.out.println("decorate :: " + node.getNodeName());
        return null;
    }

    static {
        droolsElementParserMap.put(ELEMENT_RELEASE_ID, new ReleaseIdElementParser());
        droolsElementParserMap.put(ELEMENT_KBASE_REF, new KieBaseElementParser());
        droolsElementParserMap.put(ELEMENT_KBASE, new KieBaseElementParser());
        droolsElementParserMap.put(ELEMENT_KSESSION, new KieSessionElementParser());
        droolsElementParserMap.put(ELEMENT_KSESSION_REF, new KieSessionElementParser());
        droolsElementParserMap.put(ELEMENT_EVENT_LISTENERS, new KieEventListenersElementParser());
        droolsElementParserMap.put(ELEMENT_KSTORE, new KieStoreElementParser());
        droolsElementParserMap.put(ELEMENT_ENVIRONMENT, new KieEnvironmentElementParser());
        droolsElementParserMap.put(ELEMENT_KCONTAINER, new KieContainerElementParser());
        droolsElementParserMap.put(ELEMENT_KRUNTIMEMANAGER, new KieRuntimeManagerElementParser());
        droolsElementParserMap.put(ELEMENT_KSESSION_RUNTIMEMANAGER, new KieRuntimeManagerSessionElementParser());
        droolsElementParserMap.put(ELEMENT_KMODULE, new KieModuleElementParser());
    }

    public static class PassThroughCallable<T>
    implements Callable<T> {
        private T value;

        public PassThroughCallable(T value) {
            this.value = value;
        }

        @Override
        public T call() throws Exception {
            return this.value;
        }
    }
}

