/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.reflect.PassThroughMetadataImpl;
import org.drools.core.util.StringUtils;
import org.kie.aries.blueprint.factorybeans.KBaseOptions;
import org.kie.aries.blueprint.namespace.AbstractElementParser;
import org.kie.aries.blueprint.namespace.KieSessionElementParser;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KieBaseElementParser
extends AbstractElementParser {
    private static final String ATTRIBUTE_ID = "name";
    private static final String ATTRIBUTE_PACKAGES = "packages";
    private static final String ATTRIBUTE_INCLUDES = "includes";
    private static final String ATTRIBUTE_EVENT_MODE = "eventProcessingMode";
    private static final String ATTRIBUTE_EQUALS = "equalsBehavior";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String ATTRIBUTE_DEFAULT = "default";

    public ComponentMetadata parseElement(ParserContext context, Element element) {
        String id = this.getId(context, element);
        String releaseIdRef = element.getAttribute("releaseId");
        MutableBeanMetadata beanMetadata = (MutableBeanMetadata)context.createMetadata(BeanMetadata.class);
        beanMetadata.setClassName("org.kie.aries.blueprint.factorybeans.KieObjectsFactoryBean");
        beanMetadata.setFactoryMethod("fetchKBase");
        beanMetadata.setId(id);
        beanMetadata.addArgument((Metadata)KieBaseElementParser.createValue(context, id), null, 0);
        if (!StringUtils.isEmpty((CharSequence)releaseIdRef)) {
            beanMetadata.addArgument((Metadata)KieBaseElementParser.createRef(context, releaseIdRef), null, 1);
        } else {
            beanMetadata.addArgument((Metadata)this.createNullMetadata(), null, 1);
        }
        KBaseOptions kBaseOptionsAdaptor = new KBaseOptions();
        kBaseOptionsAdaptor.setPackages(element.getAttribute(ATTRIBUTE_PACKAGES));
        kBaseOptionsAdaptor.setIncludes(element.getAttribute(ATTRIBUTE_INCLUDES));
        kBaseOptionsAdaptor.setEventProcessingMode(element.getAttribute(ATTRIBUTE_EVENT_MODE));
        kBaseOptionsAdaptor.setEqualsBehavior(element.getAttribute(ATTRIBUTE_EQUALS));
        kBaseOptionsAdaptor.setScope(element.getAttribute(ATTRIBUTE_SCOPE));
        kBaseOptionsAdaptor.setDef(element.getAttribute(ATTRIBUTE_DEFAULT));
        beanMetadata.setActivation(2);
        PassThroughMetadataImpl passThroughMetadata = (PassThroughMetadataImpl)context.createMetadata(PassThroughMetadataImpl.class);
        passThroughMetadata.setObject((Object)kBaseOptionsAdaptor);
        beanMetadata.addArgument((Metadata)passThroughMetadata, null, 2);
        String prefix = element.getPrefix();
        NodeList ksessionNodeList = element.getElementsByTagName(prefix + ":ksession");
        if (ksessionNodeList != null) {
            for (int i = 0; i < ksessionNodeList.getLength(); ++i) {
                Node ksessionNode = ksessionNodeList.item(i);
                if (!(ksessionNode instanceof Element)) continue;
                Element ksessionElement = (Element)ksessionNode;
                ksessionElement.setAttribute("id", ksessionElement.getAttribute(ATTRIBUTE_ID));
                ksessionElement.setAttribute("kbase-ref", id);
                context.getComponentDefinitionRegistry().registerComponentDefinition(new KieSessionElementParser().parseElement(context, ksessionElement));
            }
        }
        return beanMetadata;
    }
}

