/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.drools.core.util.StringUtils;
import org.kie.aries.blueprint.namespace.AbstractElementParser;
import org.kie.aries.blueprint.namespace.KieEventListenersElementParser;
import org.kie.aries.blueprint.namespace.KieSessionBatchElementParser;
import org.kie.aries.blueprint.namespace.KieSessionLoggerElementParser;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KieSessionElementParser
extends AbstractElementParser {
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_KBASE_REF = "kbase-ref";
    public static final String ATTRIBUTE_LISTENERS_REF = "listeners-ref";
    public static final String ATTRIBUTE_RELEASEID = "releaseId";
    public static final String ELEMENT_NAME_KSESSION_REF = "ksession-ref";
    public static final String ELEMENT_NAME_KSESSION = "ksession";

    public ComponentMetadata parseElement(ParserContext context, Element element) {
        String id = this.getId(context, element);
        String type = element.getAttribute(ATTRIBUTE_TYPE);
        String listenersRef = element.getAttribute(ATTRIBUTE_LISTENERS_REF);
        String kbaseRef = element.getAttribute(ATTRIBUTE_KBASE_REF);
        String releaseId = element.getAttribute(ATTRIBUTE_RELEASEID);
        String localName = element.getLocalName();
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new ComponentDefinitionException("Mandatory attribute 'id' missing for " + localName + ". Cannot continue.");
        }
        if (ELEMENT_NAME_KSESSION.equalsIgnoreCase(localName) && StringUtils.isEmpty((CharSequence)type)) {
            type = "stateful";
        }
        MutableBeanMetadata beanMetadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        beanMetadata.setActivation(2);
        beanMetadata.setId(id);
        beanMetadata.setClassName("org.kie.aries.blueprint.factorybeans.KieObjectsFactoryBean");
        beanMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, id), null, 0);
        if (StringUtils.isEmpty((CharSequence)releaseId)) {
            beanMetadata.addArgument((Metadata)this.createNullMetadata(), null, 1);
        } else {
            beanMetadata.addArgument((Metadata)KieSessionElementParser.createRef(context, releaseId), null, 1);
        }
        if (!StringUtils.isEmpty((CharSequence)listenersRef)) {
            beanMetadata.addArgument((Metadata)KieSessionElementParser.createRef(context, listenersRef), null, 2);
        } else {
            Metadata metadata = this.checkForChildListeners(context, element);
            beanMetadata.addArgument(metadata, null, 2);
        }
        MutableCollectionMetadata collectionMetadata = KieSessionLoggerElementParser.parseConsoleLoggers(this, context, element);
        beanMetadata.addArgument((Metadata)collectionMetadata, null, 3);
        collectionMetadata = KieSessionBatchElementParser.parseBatchElement(this, context, element);
        beanMetadata.addArgument((Metadata)collectionMetadata, null, 4);
        beanMetadata.setActivation(2);
        if (ELEMENT_NAME_KSESSION.equalsIgnoreCase(localName)) {
            beanMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, kbaseRef), null, 5);
            beanMetadata.addArgument((Metadata)KieSessionElementParser.createValue(context, type), null, 6);
            beanMetadata.setFactoryMethod("createKieSession");
        } else {
            beanMetadata.setFactoryMethod("createKieSessionRef");
        }
        return beanMetadata;
    }

    protected Metadata checkForChildListeners(ParserContext context, Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String localName = node.getLocalName();
            if (localName == null || !"workingMemoryEventListener".equalsIgnoreCase(localName) && !"processEventListener".equalsIgnoreCase(localName) && !"agendaEventListener".equalsIgnoreCase(localName)) continue;
            MutableBeanMetadata beanMetadata = KieEventListenersElementParser.getBeanMetadata(context, element);
            return beanMetadata;
        }
        return this.createNullMetadata();
    }
}

