/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.drools.example.api.namedkiesession.Message;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.tests.KieBlueprintListenerTest;

@Ignore
public class KieBlueprintGAVTest {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void setup() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintListenerTest.class.getResource("/org/kie/aries/blueprint/gav.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)container.getComponentInstance("namedkiesession");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testReleaseId() throws Exception {
        ReleaseId releaseId = (ReleaseId)container.getComponentInstance("rId");
        Assert.assertNotNull((Object)releaseId);
    }

    @Test
    public void testKieSessionRef() throws Exception {
        KieSession ksession = (KieSession)container.getComponentInstance("ksession1");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKSessionExecution() throws Exception {
        KieSession kSession = (KieSession)container.getComponentInstance("ksession1");
        Assert.assertNotNull((Object)kSession);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        kSession.setGlobal("out", (Object)ps);
        kSession.insert((Object)new Message("Dave", "Hello, HAL. Do you read me, HAL?"));
        kSession.fireAllRules();
        ps.close();
        String lineSeparator = System.getProperty("line.separator");
        String actual = new String(baos.toByteArray());
        String expected = "HAL: Dave. I read you." + lineSeparator + "Dave: Hello, HAL. Do you read me, HAL?" + lineSeparator;
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @AfterClass
    public static void tearDown() {
        container.destroy();
    }
}

