/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.runtime.KieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.tests.AbstractKieBlueprintDynamicModuleTest;
import org.kie.aries.blueprint.tests.KieBlueprintListenerTest;
import org.kie.scanner.MavenRepository;

public class KieBlueprintScannerTest
extends AbstractKieBlueprintDynamicModuleTest {
    private final int FIRST_VALUE = 5;
    private final int SECOND_VALUE = 10;
    private static BlueprintContainerImpl container = null;

    @Test
    public void testBlueprintKieScanner() throws Exception {
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = this.createAndInstallModule(ks, 5);
        container = KieBlueprintScannerTest.createContainer();
        this.checkForValue(5);
        this.reinstallModule(repository, ks);
        KieScanner kscanner = (KieScanner)container.getComponentInstance("blueprint-scanner-releaseId-scanner");
        kscanner.scanNow();
        this.checkForValue(10);
        ks.getRepository().removeKieModule(this.releaseId);
    }

    public static BlueprintContainerImpl createContainer() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintListenerTest.class.getResource("/org/kie/aries/blueprint/kie-scanner.xml"));
        return new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    protected void reinstallModule(MavenRepository repository, KieServices ks) throws IOException {
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, this.releaseId, 10);
        File kPom = this.createKPom(this.releaseId);
        repository.installArtifact(this.releaseId, kJar2, kPom);
    }

    protected void checkForValue(int value) {
        ArrayList list = new ArrayList();
        KieBase kieBase = (KieBase)container.getComponentInstance("KBase1");
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertTrue((String)("Expected:<" + value + "> but was:<" + list.get(0) + ">"), ((Integer)list.get(0) == value ? 1 : 0) != 0);
    }
}

