/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import javax.naming.Context;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.camel.component.KieCamelTestSupport;
import org.kie.pipeline.camel.Person;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class CamelEndpointActionInsertTest
extends KieCamelTestSupport {
    private KieSession ksession;
    private AgendaEventListener ael;
    private WorkingMemoryEventListener wmel;

    @Test
    public void testSessionInsert() throws Exception {
        Person person = new Person();
        person.setName("Bob");
        this.template.sendBody("direct:test-no-ep", (Object)person);
        ArgumentCaptor oie = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)this.wmel)).objectInserted((ObjectInsertedEvent)oie.capture());
        CamelEndpointActionInsertTest.assertThat((Object)((Person)((ObjectInsertedEvent)oie.getValue()).getObject()), (Matcher)CoreMatchers.is((Object)person));
    }

    @Test
    public void testSessionInsertEntryPoint() throws Exception {
        Person person = new Person();
        person.setName("Bob");
        this.template.sendBody("direct:test-with-ep", (Object)person);
        ArgumentCaptor oie = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)this.wmel)).objectInserted((ObjectInsertedEvent)oie.capture());
        CamelEndpointActionInsertTest.assertThat((Object)((Person)((ObjectInsertedEvent)oie.getValue()).getObject()), (Matcher)CoreMatchers.is((Object)person));
    }

    @Test
    public void testSessionInsertMessage() throws Exception {
        Person person = new Person();
        person.setName("Bob");
        this.template.sendBody("direct:test-message", (Object)person);
        ArgumentCaptor oie = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)this.wmel)).objectInserted((ObjectInsertedEvent)oie.capture());
        CamelEndpointActionInsertTest.assertThat((Object)((Person)((Message)((ObjectInsertedEvent)oie.getValue()).getObject()).getBody()), (Matcher)CoreMatchers.is((Object)person));
    }

    @Test
    public void testSessionInsertExchange() throws Exception {
        Person person = new Person();
        person.setName("Bob");
        this.template.sendBody("direct:test-exchange", (Object)person);
        ArgumentCaptor oie = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)this.wmel)).objectInserted((ObjectInsertedEvent)oie.capture());
        CamelEndpointActionInsertTest.assertThat((Object)((Person)((Exchange)((ObjectInsertedEvent)oie.getValue()).getObject()).getIn().getBody()), (Matcher)CoreMatchers.is((Object)person));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:test-no-ep").to("kie://ksession1?action=insertBody");
                this.from("direct:test-with-ep").to("kie://ksession1?action=insertBody&entryPoint=ep1");
                this.from("direct:test-message").to("kie://ksession1?action=insertMessage");
                this.from("direct:test-exchange").to("kie://ksession1?action=insertExchange");
            }
        };
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        String rule = "";
        rule = rule + "package org.kie.pipeline.camel \n";
        rule = rule + "import org.apache.camel.Exchange \n";
        rule = rule + "import org.apache.camel.Message \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + "  then \n";
        rule = rule + "    // no-op \n";
        rule = rule + "end\n";
        rule = rule + "rule rule2 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() from entry-point ep1 \n";
        rule = rule + "  then \n";
        rule = rule + "    // no-op \n";
        rule = rule + "end\n";
        rule = rule + "rule rule3 \n";
        rule = rule + "  when \n";
        rule = rule + "    $m : Message() \n";
        rule = rule + "  then \n";
        rule = rule + "    // no-op \n";
        rule = rule + "end\n";
        rule = rule + "rule rule4 \n";
        rule = rule + "  when \n";
        rule = rule + "    $e : Exchange() \n";
        rule = rule + "  then \n";
        rule = rule + "    // no-op \n";
        rule = rule + "end\n";
        this.ksession = this.registerKnowledgeRuntime("ksession1", rule);
        this.ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.wmel = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        this.ksession.addEventListener(this.ael);
        this.ksession.addEventListener(this.wmel);
    }
}

