/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.file.PathUtils;
import org.eclipse.aether.transport.file.ResourceNotFoundException;

final class FileTransporter
extends AbstractTransporter {
    private final Logger logger;
    private final File basedir;

    public FileTransporter(RemoteRepository repository, Logger logger) throws NoTransporterException {
        if (!"file".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.logger = logger;
        this.basedir = new File(PathUtils.basedir(repository.getUrl())).getAbsoluteFile();
    }

    File getBasedir() {
        return this.basedir;
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    protected void implPeek(PeekTask task) throws Exception {
        this.getFile(task, true);
    }

    protected void implGet(GetTask task) throws Exception {
        File file = this.getFile(task, true);
        this.utilGet(task, new FileInputStream(file), true, file.length(), false);
    }

    protected void implPut(PutTask task) throws Exception {
        File file = this.getFile(task, false);
        file.getParentFile().mkdirs();
        try {
            this.utilPut(task, new FileOutputStream(file), true);
        }
        catch (Exception e) {
            if (!file.delete() && file.exists()) {
                this.logger.debug("Could not delete partial file " + file);
            }
            throw e;
        }
    }

    private File getFile(TransportTask task, boolean required) throws Exception {
        String path = task.getLocation().getPath();
        if (path.contains("../")) {
            throw new IllegalArgumentException("Illegal resource path: " + path);
        }
        File file = new File(this.basedir, path);
        if (required && !file.exists()) {
            throw new ResourceNotFoundException("Could not locate " + file);
        }
        return file;
    }

    protected void implClose() {
    }
}

