/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.wagon.Wagon;
import org.kie.scanner.IoUtils;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.file.FileRepositoryConnectorFactory;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.maven.wagon.AhcWagon;

public class Aether {
    private static final String M2_REPO = System.getProperty("user.home") + "/.m2/repository";
    private String localRepoDir = M2_REPO;
    public static final Aether DEFUALT_AETHER = new Aether();
    private final RepositorySystem system = this.newRepositorySystem();
    private final RepositorySystemSession session = this.newRepositorySystemSession(this.system);
    private final List<RemoteRepository> repositories;
    private RemoteRepository localRepository;

    private Aether() {
        this(MavenProjectLoader.loadMavenProject());
    }

    Aether(MavenProject mavenProject) {
        this.repositories = this.initRepositories(mavenProject);
    }

    private List<RemoteRepository> initRepositories(MavenProject mavenProject) {
        ArrayList<RemoteRepository> reps = new ArrayList<RemoteRepository>();
        if (mavenProject != null) {
            reps.addAll(mavenProject.getRemoteProjectRepositories());
        } else {
            reps.add(this.newCentralRepository());
        }
        RemoteRepository localRepo = this.newLocalRepository();
        if (localRepo != null) {
            reps.add(localRepo);
            this.localRepository = localRepo;
        } else {
            this.localRepoDir = IoUtils.getTmpDirectory().getAbsolutePath();
        }
        return reps;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        LocalRepository localRepo = new LocalRepository(this.localRepoDir);
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    private RemoteRepository newCentralRepository() {
        return new RemoteRepository("central", "default", "http://repo1.maven.org/maven2/");
    }

    private RemoteRepository newLocalRepository() {
        File m2RepoDir = new File(M2_REPO);
        if (!m2RepoDir.exists()) {
            return null;
        }
        try {
            String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
            return new RemoteRepository("local", "default", localRepositoryUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public RemoteRepository getLocalRepository() {
        return this.localRepository;
    }

    private static class ManualWagonProvider
    implements WagonProvider {
        private ManualWagonProvider() {
        }

        public Wagon lookup(String roleHint) throws Exception {
            if ("http".equals(roleHint)) {
                return new AhcWagon();
            }
            return null;
        }

        public void release(Wagon wagon) {
        }
    }
}

