/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.management;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.scanner.KieRepositoryScannerImpl;
import org.kie.scanner.management.KieScannerMBeanImpl;
import org.kie.scanner.management.MBeanUtils;

public class KieScannerMBeanTest
extends AbstractKieCiTest {
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        MBeanUtils.setMBeanEnabled((boolean)true);
        System.setProperty("kie.scanner.mbeans", "enabled");
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
        System.setProperty("kie.scanner.mbeans", "");
        MBeanUtils.setMBeanEnabled((boolean)false);
    }

    @Test
    public void testKScannerMBean() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-mbean-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        KieRepositoryScannerImpl scanner = (KieRepositoryScannerImpl)ks.newKieScanner(kieContainer);
        KieScannerMBeanImpl mBean = (KieScannerMBeanImpl)scanner.getMBean();
        ObjectName mbeanName = mBean.getMBeanName();
        Assert.assertEquals((Object)releaseId.toExternalForm(), (Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"ScannerReleaseId"));
        Assert.assertEquals((Object)releaseId.toExternalForm(), (Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"CurrentReleaseId"));
        Assert.assertEquals((Object)KieScanner.Status.STOPPED.toString(), (Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status"));
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"start", (Object[])new Object[]{10000L}, (String[])new String[]{"long"});
        Assert.assertEquals((Object)KieScanner.Status.RUNNING.toString(), (Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status"));
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"stop", (Object[])new Object[0], (String[])new String[0]);
        Assert.assertEquals((Object)KieScanner.Status.STOPPED.toString(), (Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status"));
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
        repository.installArtifact((AFReleaseId)releaseId, kJar2, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"scanNow", (Object[])new Object[0], (String[])new String[0]);
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
        MBeanUtils.invoke((ObjectName)mbeanName, (String)"shutdown", (Object[])new Object[0], (String[])new String[0]);
        Assert.assertEquals((Object)KieScanner.Status.SHUTDOWN.toString(), (Object)MBeanUtils.getAttribute((ObjectName)mbeanName, (String)"Status"));
        ks.getRepository().removeKieModule(releaseId);
    }

    @Override
    protected void checkKSession(KieSession ksession, Object ... results) {
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)results.length, (long)list.size());
        for (Object result : results) {
            Assert.assertTrue((boolean)list.contains(result));
        }
    }
}

