/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.builder.Builder;
import org.guvnor.common.services.builder.LRUBuilderCache;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.DeployResult;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private Paths paths;
    private POMService pomService;
    private ExtendedM2RepoService m2RepoService;
    private ProjectService projectService;
    private LRUBuilderCache cache;
    private Event<DeployResult> deployResultEvent;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(Paths paths, POMService pomService, ExtendedM2RepoService m2RepoService, ProjectService projectService, LRUBuilderCache cache, Event<DeployResult> deployResultEvent) {
        this.paths = paths;
        this.pomService = pomService;
        this.m2RepoService = m2RepoService;
        this.projectService = projectService;
        this.cache = cache;
        this.deployResultEvent = deployResultEvent;
    }

    public BuildResults build(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public BuildResults buildAndDeploy(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            POM pom = (POM)this.pomService.load(project.getPomXMLPath());
            if (results.getMessages().isEmpty()) {
                Builder builder = this.cache.assertBuilder(project);
                InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
                ByteArrayInputStream input = new ByteArrayInputStream(kieModule.getBytes());
                this.m2RepoService.deployJar((InputStream)input, pom.getGav());
                DeployResult deployResult = new DeployResult(pom.getGav());
                deployResult.setBuildMessages(results.getMessages());
                this.deployResultEvent.fire((Object)deployResult);
            } else {
                DeployResult deployResult = new DeployResult(pom.getGav());
                deployResult.setBuildMessages(results.getMessages());
                this.deployResultEvent.fire((Object)deployResult);
            }
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private BuildResults doBuild(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        BuildResults results = builder.build();
        return results;
    }

    public boolean isBuilt(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        return builder.isBuilt();
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.addResource(this.paths.convert(resource));
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.deleteResource(this.paths.convert(resource));
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.updateResource(this.paths.convert(resource));
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults applyBatchResourceChanges(Project project, Set<ResourceChange> changes) {
        IncrementalBuildResults results = new IncrementalBuildResults();
        try {
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.applyBatchResourceChanges(changes);
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

