/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.builder.Builder;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.commons.io.IOService;
import org.kie.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class LRUBuilderCache
extends LRUCache<Project, Builder> {
    @Inject
    private Paths paths;
    @Inject
    private POMService pomService;
    @Inject
    private ProjectService projectService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Any
    private Instance<BuildValidationHelper> anyValidators;
    private final List<BuildValidationHelper> validators = new ArrayList<BuildValidationHelper>();

    @PostConstruct
    public void setupValidators() {
        Iterator itr = this.anyValidators.iterator();
        while (itr.hasNext()) {
            this.validators.add((BuildValidationHelper)itr.next());
        }
    }

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Path resourcePath = event.getResourcePath();
        Project project = this.projectService.resolveProject(resourcePath);
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized Builder assertBuilder(Project project) {
        Builder builder = (Builder)this.getEntry(project);
        if (builder == null) {
            Path pathToPom = project.getPomXMLPath();
            POM pom = (POM)this.pomService.load(pathToPom);
            builder = new Builder(this.paths.convert(project.getRootPath()), pom.getGav(), this.paths, this.ioService, this.projectService, this.validators);
            this.setEntry(project, builder);
        }
        return builder;
    }
}

