/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.server.auth.source.AbstractDatabaseAuthSource;

public class DSAuthSource
extends AbstractDatabaseAuthSource
implements AuthenticationSource {
    private DataSource dataSource;

    @Override
    public void initialize(Map<String, ?> options) {
        try {
            super.initialize(options);
            String dbJNDIName = (String)options.get("dbJNDIName");
            InitialContext ic = new InitialContext();
            this.dataSource = (DataSource)ic.lookup("java:comp/env/" + dbJNDIName);
        }
        catch (NamingException e) {
            throw new IllegalStateException(e.toString(), e);
        }
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e.toString(), e);
        }
    }
}

