/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kie.commons.validation.Preconditions;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.impl.auth.UserNameCredential;
import org.uberfire.security.impl.auth.UsernamePasswordCredential;
import org.uberfire.security.server.auth.source.JACCAuthenticationSource;

public class HttpServletRequestAuthenticationSource
extends JACCAuthenticationSource {
    @Override
    public boolean supportsCredential(Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential instanceof UserNameCredential;
    }

    @Override
    public boolean authenticate(Credential credential) {
        try {
            UserNameCredential userNameCredential = (UserNameCredential)Preconditions.checkInstanceOf((String)"credential", (Object)credential, UserNameCredential.class);
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            if (subject != null) {
                return super.authenticate(credential);
            }
            if (userNameCredential instanceof UsernamePasswordCredential) {
                HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
                try {
                    request.login(userNameCredential.getUserName(), ((UsernamePasswordCredential)userNameCredential).getPassword().toString());
                }
                catch (ServletException ex) {
                    return false;
                }
            }
            return super.authenticate(credential);
        }
        catch (Exception e) {
            return false;
        }
    }
}

