/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedMetaInfFolderFilter;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ResourceContext;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.uberfire.backend.group.Group;
import org.uberfire.backend.group.GroupService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.security.Resource;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class ExplorerServiceImpl
implements ExplorerService {
    private static final String MAIN_SRC_PATH = "src/main/java";
    private static final String TEST_SRC_PATH = "src/test/java";
    private static final String MAIN_RESOURCES_PATH = "src/main/resources";
    private static final String TEST_RESOURCES_PATH = "src/test/resources";
    private static String[] sourcePaths = new String[]{"src/main/java", "src/main/resources", "src/test/java", "src/test/resources"};
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    private LinkedMetaInfFolderFilter metaDataFileFilter = new LinkedMetaInfFolderFilter();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ProjectService projectService;
    @Inject
    private GroupService groupService;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @SessionScoped
    private Identity identity;
    @Inject
    private Paths paths;

    public ExplorerServiceImpl() {
    }

    public ExplorerServiceImpl(IOService ioService, AuthorizationManager authorizationManager, ProjectService projectService, GroupService groupService, Identity identity, Paths paths) {
        this.ioService = ioService;
        this.authorizationManager = authorizationManager;
        this.projectService = projectService;
        this.groupService = groupService;
        this.identity = identity;
        this.paths = paths;
    }

    public Collection<Group> getGroups() {
        Collection groups = this.groupService.getGroups();
        ArrayList<Group> authorizedGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!this.authorizationManager.authorize((Resource)group, (Subject)this.identity)) continue;
            authorizedGroups.add(group);
        }
        return authorizedGroups;
    }

    public Collection<Repository> getRepositories(Group group) {
        HashSet<Repository> authorizedRepositories = new HashSet<Repository>();
        if (group == null) {
            return authorizedRepositories;
        }
        Collection repositories = this.groupService.getGroup(group.getName()).getRepositories();
        for (Repository repository : repositories) {
            if (!this.authorizationManager.authorize((Resource)repository, (Subject)this.identity)) continue;
            authorizedRepositories.add(repository);
        }
        return authorizedRepositories;
    }

    public Collection<Project> getProjects(Repository repository) {
        HashSet<Project> authorizedProjects = new HashSet<Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        org.uberfire.backend.vfs.Path repositoryRoot = repository.getRoot();
        DirectoryStream nioRepositoryPaths = this.ioService.newDirectoryStream(this.paths.convert(repositoryRoot));
        for (Path nioRepositoryPath : nioRepositoryPaths) {
            org.uberfire.backend.vfs.Path projectPath;
            Project project;
            if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0]) || (project = this.projectService.resolveProject(projectPath = this.paths.convert(nioRepositoryPath))) == null || !this.authorizationManager.authorize((Resource)project, (Subject)this.identity)) continue;
            authorizedProjects.add(project);
        }
        return authorizedProjects;
    }

    public Collection<Package> getPackages(Project project) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (project == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRootPath = this.paths.convert(projectRoot);
        for (String src : sourcePaths) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : sourcePaths) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.makePackage(nioPackagePath));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    private Set<String> getPackageNames(Path nioProjectRootPath, Path nioPackageSrcPath) {
        HashSet<String> packageNames = new HashSet<String>();
        if (!Files.exists((Path)nioPackageSrcPath, (LinkOption[])new LinkOption[0])) {
            return packageNames;
        }
        packageNames.add(this.getPackagePathSuffix(nioProjectRootPath, nioPackageSrcPath));
        DirectoryStream nioChildPackageSrcPaths = this.ioService.newDirectoryStream(nioPackageSrcPath, (DirectoryStream.Filter)this.metaDataFileFilter);
        for (Path nioChildPackageSrcPath : nioChildPackageSrcPaths) {
            if (!Files.isDirectory((Path)nioChildPackageSrcPath, (LinkOption[])new LinkOption[0])) continue;
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioChildPackageSrcPath));
        }
        return packageNames;
    }

    private String getPackagePathSuffix(Path nioProjectRootPath, Path nioPackagePath) {
        Path nioMainSrcPath = nioProjectRootPath.resolve(MAIN_SRC_PATH);
        Path nioTestSrcPath = nioProjectRootPath.resolve(TEST_SRC_PATH);
        Path nioMainResourcesPath = nioProjectRootPath.resolve(MAIN_RESOURCES_PATH);
        Path nioTestResourcesPath = nioProjectRootPath.resolve(TEST_RESOURCES_PATH);
        String packageName = null;
        Path packagePath = null;
        if (nioPackagePath.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        }
        return packageName;
    }

    private Package makePackage(Path nioPackageSrcPath) {
        Package pkg = this.projectService.resolvePackage(this.paths.convert(nioPackageSrcPath, false));
        return pkg;
    }

    public Collection<FolderItem> getItems(Package pkg) {
        HashSet<FolderItem> folderItems = new HashSet<FolderItem>();
        if (pkg == null) {
            return folderItems;
        }
        folderItems.addAll(this.getItems(pkg.getPackageMainSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageMainResourcesPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestResourcesPath()));
        return folderItems;
    }

    private Collection<FolderItem> getItems(org.uberfire.backend.vfs.Path packagePath) {
        HashSet<FolderItem> folderItems = new HashSet<FolderItem>();
        Path nioPackagePath = this.paths.convert(packagePath);
        if (Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPackagePath, (DirectoryStream.Filter)this.dotFileFilter);
            for (Path nioPath : nioPaths) {
                if (!Files.isRegularFile((Path)nioPath, (LinkOption[])new LinkOption[0])) continue;
                org.uberfire.backend.vfs.Path path = this.paths.convert(nioPath);
                FolderItem folderItem = new FolderItem(path, path.getFileName(), FolderItemType.FILE);
                folderItems.add(folderItem);
            }
        }
        return folderItems;
    }

    public FolderListing getFolderListing(org.uberfire.backend.vfs.Path path) {
        HashSet<FolderItem> folderItems = new HashSet<FolderItem>();
        Path nioPath = this.paths.convert(path);
        while (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            nioPath = nioPath.getParent();
        }
        org.uberfire.backend.vfs.Path basePath = this.paths.convert(nioPath);
        org.uberfire.backend.vfs.Path baseParentPath = this.paths.convert(nioPath.getParent());
        DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPath, (DirectoryStream.Filter)this.dotFileFilter);
        for (Path np : nioPaths) {
            FolderItem folderItem;
            org.uberfire.backend.vfs.Path p;
            if (Files.isRegularFile((Path)np, (LinkOption[])new LinkOption[0])) {
                p = this.paths.convert(np);
                folderItem = new FolderItem(p, p.getFileName(), FolderItemType.FILE);
                folderItems.add(folderItem);
                continue;
            }
            if (!Files.isDirectory((Path)np, (LinkOption[])new LinkOption[0])) continue;
            p = this.paths.convert(np);
            folderItem = new FolderItem(p, p.getFileName(), FolderItemType.FOLDER);
            folderItems.add(folderItem);
        }
        List<org.uberfire.backend.vfs.Path> segments = this.getPathSegments(basePath);
        return new FolderListing(basePath, baseParentPath, folderItems, segments);
    }

    private List<org.uberfire.backend.vfs.Path> getPathSegments(org.uberfire.backend.vfs.Path path) {
        Path nioSegmentPath = this.paths.convert(path);
        int segmentCount = nioSegmentPath.getNameCount() - 1;
        if (segmentCount < 1) {
            return new ArrayList<org.uberfire.backend.vfs.Path>();
        }
        org.uberfire.backend.vfs.Path[] segments = new org.uberfire.backend.vfs.Path[segmentCount];
        for (int idx = segmentCount; idx > 0; --idx) {
            segments[idx - 1] = this.paths.convert(nioSegmentPath);
            nioSegmentPath = nioSegmentPath.getParent();
        }
        return Arrays.asList(segments);
    }

    public ResourceContext resolveResourceContext(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return new ResourceContext();
        }
        Project project = this.projectService.resolveProject(path);
        Package pkg = this.projectService.resolvePackage(path);
        return new ResourceContext(project, pkg);
    }
}

