/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.sonatype.guice.bean.locators.ImplicitBindings;
import org.sonatype.guice.bean.locators.LazyBeanEntry;
import org.sonatype.guice.bean.locators.QualifyingStrategy;
import org.sonatype.guice.bean.locators.RankedBindings;
import org.sonatype.guice.bean.locators.RankedList;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocatedBeans<Q extends Annotation, T>
implements Iterable<BeanEntry<Q, T>> {
    final Key<T> key;
    final RankedBindings<T> explicitBindings;
    final ImplicitBindings implicitBindings;
    final QualifyingStrategy strategy;
    volatile Map<Binding<T>, BeanEntry<Q, T>> readCache = Collections.EMPTY_MAP;

    LocatedBeans(Key<T> key, RankedBindings<T> explicitBindings, ImplicitBindings implicitBindings) {
        this.key = key;
        this.explicitBindings = explicitBindings;
        this.implicitBindings = implicitBindings;
        this.strategy = QualifyingStrategy.selectFor(key);
        explicitBindings.linkToBeans(this);
    }

    @Override
    public Iterator<BeanEntry<Q, T>> iterator() {
        return new Itr();
    }

    synchronized void retainAll(RankedList<Binding<T>> activeBindings) {
        if (this.readCache.size() > 0) {
            Map tempCache = (Map)((IdentityHashMap)this.readCache).clone();
            Iterator i = tempCache.entrySet().iterator();
            while (i.hasNext()) {
                if (activeBindings.indexOfThis(i.next().getKey()) >= 0) continue;
                i.remove();
            }
            this.readCache = tempCache;
        }
    }

    synchronized BeanEntry<Q, T> cacheBean(Q qualifier, Binding<T> binding, int rank) {
        BeanEntry<Q, T> bean = this.readCache.get(binding);
        if (null == bean) {
            bean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
            IdentityHashMap<Binding<T>, BeanEntry<Q, T>> tempCache = this.readCache.size() > 0 ? (Map)((IdentityHashMap)this.readCache).clone() : new IdentityHashMap<Binding<T>, BeanEntry<Q, T>>();
            tempCache.put(binding, bean);
            this.readCache = tempCache;
        }
        return bean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Itr
    implements Iterator<BeanEntry<Q, T>> {
        private final RankedBindings.Itr itr;
        private boolean checkImplicitBindings;
        private BeanEntry<Q, T> nextBean;

        Itr() {
            this.itr = LocatedBeans.this.explicitBindings.iterator();
            this.checkImplicitBindings = LocatedBeans.this.implicitBindings != null;
        }

        @Override
        public boolean hasNext() {
            Binding binding;
            if (null != this.nextBean) {
                return true;
            }
            while (this.itr.hasNext()) {
                binding = this.itr.next();
                this.nextBean = LocatedBeans.this.readCache.get(binding);
                if (null != this.nextBean) {
                    return true;
                }
                Annotation qualifier = LocatedBeans.this.strategy.qualifies(LocatedBeans.this.key, binding);
                if (null == qualifier) continue;
                this.nextBean = LocatedBeans.this.cacheBean(qualifier, binding, this.itr.rank());
                return true;
            }
            if (this.checkImplicitBindings && null != (binding = LocatedBeans.this.implicitBindings.get(LocatedBeans.this.key.getTypeLiteral()))) {
                this.nextBean = LocatedBeans.this.cacheBean(QualifyingStrategy.DEFAULT_QUALIFIER, binding, Integer.MIN_VALUE);
                return true;
            }
            return false;
        }

        @Override
        public BeanEntry<Q, T> next() {
            if (this.hasNext()) {
                this.checkImplicitBindings = false;
                BeanEntry bean = this.nextBean;
                this.nextBean = null;
                return bean;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

