/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import org.drools.core.util.AbstractXStreamConverter;
import org.guvnor.common.services.project.model.QualifierModel;

public class QualifierConverter
extends AbstractXStreamConverter {
    public QualifierConverter() {
        super(QualifierModel.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        QualifierModel qualifier = (QualifierModel)value;
        writer.addAttribute("type", qualifier.getType());
        if (qualifier.getValue() != null) {
            writer.addAttribute("value", qualifier.getValue());
        } else {
            for (Map.Entry entry : qualifier.getArguments().entrySet()) {
                writer.startNode("arg");
                writer.addAttribute("key", (String)entry.getKey());
                writer.addAttribute("value", (String)entry.getValue());
                writer.endNode();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        final QualifierModel qualifier = new QualifierModel();
        qualifier.setType(reader.getAttribute("type"));
        String value = reader.getAttribute("value");
        if (value != null) {
            qualifier.setValue(value);
        } else {
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("arg".equals(name)) {
                        qualifier.addArgument(reader.getAttribute("key"), reader.getAttribute("value"));
                    }
                }
            });
        }
        return qualifier;
    }
}

