/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.compiler.execmodelbased.DecisionTableEvaluator;
import org.kie.dmn.core.compiler.execmodelbased.FeelValue;
import org.kie.dmn.core.impl.DMNDecisionResultImpl;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTable;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesMatchedEvent;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;

public abstract class DMNUnit
implements RuleUnit {
    private EvaluationContext evalCtx;
    private DecisionTable decisionTable;
    protected Object result;
    private DecisionTableEvaluator evaluator;
    private List<FEELEvent> events;

    public Object getResult() {
        return this.result;
    }

    DMNDecisionResult execute(String decisionId, RuleUnitExecutor executor) {
        executor.run((RuleUnit)this);
        return new DMNDecisionResultImpl(decisionId, this.decisionTable.getName(), DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, this.getResult(), Collections.emptyList());
    }

    protected FeelValue getValue(int pos) {
        return this.evaluator.getInputs()[pos];
    }

    DMNUnit setEvalCtx(EvaluationContext evalCtx) {
        this.evalCtx = evalCtx;
        return this;
    }

    DMNUnit setDecisionTable(DecisionTable decisionTable) {
        this.decisionTable = decisionTable;
        return this;
    }

    DMNUnit setDecisionTableEvaluator(DecisionTableEvaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    DMNUnit setEvents(List<FEELEvent> events) {
        this.events = events;
        return this;
    }

    public DecisionTableEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected Object applyHitPolicy(List<Object> ... results) {
        HitPolicy hitPolicy = this.evaluator.getHitPolicy();
        if (this.evaluator.getIndexes().isEmpty()) {
            if (this.evaluator.hasDefaultValues()) {
                return this.evaluator.defaultToOutput(this.evalCtx);
            }
            if (hitPolicy.getDefaultValue() != null) {
                return hitPolicy.getDefaultValue();
            }
            this.events.add((FEELEvent)new HitPolicyViolationEvent(FEELEvent.Severity.WARN, "No rule matched for decision table '" + this.decisionTable.getName() + "' and no default values were defined. Setting result to null.", this.decisionTable.getName(), Collections.EMPTY_LIST));
        }
        List matches = this.evaluator.getIndexes().stream().map(i -> () -> i).collect(Collectors.toList());
        this.evalCtx.notifyEvt(() -> {
            List matchedIndexes = matches.stream().map(dr -> dr.getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesMatchedEvent(FEELEvent.Severity.INFO, "Rules matched for decision table '" + this.decisionTable.getName() + "': " + matches.toString(), this.decisionTable.getName(), this.decisionTable.getName(), matchedIndexes);
        });
        List<Object> combinedResults = results.length == 1 ? results[0] : this.combineResults(results);
        Map msgs = DecisionTableImpl.checkResults((List)this.decisionTable.getOutputs(), (EvaluationContext)this.evalCtx, matches, combinedResults);
        if (!msgs.isEmpty()) {
            List offending = msgs.keySet().stream().collect(Collectors.toList());
            this.events.add((FEELEvent)new HitPolicyViolationEvent(FEELEvent.Severity.ERROR, "Errors found evaluating decision table '" + this.decisionTable.getName() + "': \n" + msgs.values().stream().collect(Collectors.joining("\n")), this.decisionTable.getName(), offending));
            return null;
        }
        return hitPolicy.getDti().dti(this.evalCtx, this.decisionTable, matches, combinedResults);
    }

    private List<Object> combineResults(List<Object>[] results) {
        int resultSize = results[0].size();
        ArrayList<Object> resultsAsMap = new ArrayList<Object>();
        for (int i = 0; i < resultSize; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int j = 0; j < results.length; ++j) {
                map.put(((DecisionTable.OutputClause)this.decisionTable.getOutputs().get(j)).getName(), results[j].get(i));
            }
            resultsAsMap.add(map);
        }
        return resultsAsMap;
    }
}

