/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNAssemblerTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNAssemblerTest.class);

    @Test
    public void testDuplicateModel() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ks.getResources().newClassPathResource("0001-input-data-string.dmn", this.getClass()));
        kfs.write(ks.getResources().newClassPathResource("duplicate.0001-input-data-string.dmn", this.getClass()));
        Results results = ks.newKieBuilder(kfs).buildAll().getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.ERROR}).forEach(e -> LOG.error("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.ERROR}).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExtendedMode() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("strictMode.dmn", this.getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "strictMode");
        DMNContext ctx = runtime.newContext();
        ctx.set("timestring", (Object)"2016-12-20T14:30:22z");
        DMNResult result = runtime.evaluateAll(model, ctx);
        Assert.assertEquals((Object)DateTimeFormatter.ISO_TIME.parse((CharSequence)"14:30:22z", OffsetTime::from), (Object)result.getDecisionResultByName("time").getResult());
    }

    @Test
    public void testStrictMode() {
        System.setProperty("org.kie.dmn.strictConformance", "true");
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("strictMode.dmn", this.getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "strictMode");
        DMNContext ctx = runtime.newContext();
        ctx.set("timestring", (Object)"2016-12-20T14:30:22z");
        DMNResult result = runtime.evaluateAll(model, ctx);
        Assert.assertNull((Object)result.getDecisionResultByName("time").getResult());
    }

    @Test
    public void testStrictModeProp() {
        KieServices services = KieServices.Factory.get();
        KieFileSystem fileSystem = services.newKieFileSystem();
        KieModuleModel moduleModel = services.newKieModuleModel();
        moduleModel.setConfigurationProperty("org.kie.dmn.strictConformance", "true");
        fileSystem.writeKModuleXML(moduleModel.toXML());
        fileSystem.write(services.getResources().newClassPathResource("strictMode.dmn", this.getClass()));
        services.newKieBuilder(fileSystem).buildAll();
        KieContainer container = services.newKieContainer(services.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)container.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "strictMode");
        DMNContext ctx = runtime.newContext();
        ctx.set("timestring", (Object)"2016-12-20T14:30:22z");
        DMNResult result = runtime.evaluateAll(model, ctx);
        Assert.assertNull((Object)result.getDecisionResultByName("time").getResult());
    }

    @After
    public void clearSystemProperty() {
        System.clearProperty("org.kie.dmn.strictConformance");
    }
}

