/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.ItemDefNode;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.types.AliasFEELType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNCompilerTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNCompilerTest.class);

    @Test
    public void testItemDefAllowedValuesString() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0003-input-data-string-allowed-values.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0003-input-data-string-allowed-values");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        ItemDefNode itemDef = dmnModel.getItemDefinitionByName("tEmploymentStatus");
        Assert.assertThat((Object)itemDef.getName(), (Matcher)CoreMatchers.is((Object)"tEmploymentStatus"));
        Assert.assertThat((Object)itemDef.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        DMNType type = itemDef.getType();
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)type.getName(), (Matcher)CoreMatchers.is((Object)"tEmploymentStatus"));
        Assert.assertThat((Object)type.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SimpleTypeImpl.class)));
        SimpleTypeImpl feelType = (SimpleTypeImpl)type;
        EvaluationContextImpl ctx = new EvaluationContextImpl(ClassLoaderUtil.findDefaultClassLoader(), null);
        Assert.assertThat((Object)feelType.getFeelType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AliasFEELType.class)));
        Assert.assertThat((Object)((AliasFEELType)feelType.getFeelType()).getName(), (Matcher)CoreMatchers.is((Object)"tEmploymentStatus"));
        Assert.assertThat((Object)feelType.getAllowedValuesFEEL().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((UnaryTest)feelType.getAllowedValuesFEEL().get(0)).apply((Object)ctx, (Object)"UNEMPLOYED"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((UnaryTest)feelType.getAllowedValuesFEEL().get(1)).apply((Object)ctx, (Object)"EMPLOYED"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((UnaryTest)feelType.getAllowedValuesFEEL().get(2)).apply((Object)ctx, (Object)"SELF-EMPLOYED"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((UnaryTest)feelType.getAllowedValuesFEEL().get(3)).apply((Object)ctx, (Object)"STUDENT"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCompositeItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0008-LX-arithmetic.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0008-LX-arithmetic");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        ItemDefNode itemDef = dmnModel.getItemDefinitionByName("tLoan");
        Assert.assertThat((Object)itemDef.getName(), (Matcher)CoreMatchers.is((Object)"tLoan"));
        Assert.assertThat((Object)itemDef.getId(), (Matcher)CoreMatchers.is((Object)"tLoan"));
        DMNType type = itemDef.getType();
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)type.getName(), (Matcher)CoreMatchers.is((Object)"tLoan"));
        Assert.assertThat((Object)type.getId(), (Matcher)CoreMatchers.is((Object)"tLoan"));
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CompositeTypeImpl.class)));
        CompositeTypeImpl compType = (CompositeTypeImpl)type;
        Assert.assertThat((Object)compType.getFields().size(), (Matcher)CoreMatchers.is((Object)3));
        DMNType principal = (DMNType)compType.getFields().get("principal");
        Assert.assertThat((Object)principal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)principal.getName(), (Matcher)CoreMatchers.is((Object)"number"));
        Assert.assertThat((Object)((SimpleTypeImpl)principal).getFeelType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        DMNType rate = (DMNType)compType.getFields().get("rate");
        Assert.assertThat((Object)rate, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)rate.getName(), (Matcher)CoreMatchers.is((Object)"number"));
        Assert.assertThat((Object)((SimpleTypeImpl)rate).getFeelType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        DMNType termMonths = (DMNType)compType.getFields().get("termMonths");
        Assert.assertThat((Object)termMonths, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)termMonths.getName(), (Matcher)CoreMatchers.is((Object)"number"));
        Assert.assertThat((Object)((SimpleTypeImpl)termMonths).getFeelType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
    }

    @Test
    public void testCompilationThrowsNPE() {
        try {
            DMNRuntimeUtil.createRuntime("compilationThrowsNPE.dmn", this.getClass());
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Unable to compile DMN model for the resource"));
        }
    }

    @Test
    public void testRecursiveFunctions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Recursive.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "Recursive");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((boolean)runtime.evaluateAll(dmnModel, DMNFactory.newContext()).hasErrors());
    }

    @Test
    public void testImport() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Importing_Model.dmn", this.getClass(), "Imported_Model.dmn");
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_f27bb64b-6fc7-4e1f-9848-11ba35e0df36", "Imported Model");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        for (Object message : importedModel.getMessages()) {
            LOG.debug("{}", message);
        }
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_f79aa7a4-f9a3-410a-ac95-bea496edab52", "Importing Model");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        for (DMNMessage message : dmnModel.getMessages()) {
            LOG.debug("{}", (Object)message);
        }
        DMNContext context = runtime.newContext();
        context.set("A Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("name", "John"), DynamicTypeUtils.entry("age", 47)));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        for (DMNMessage message : evaluateAll.getMessages()) {
            LOG.debug("{}", (Object)message);
        }
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Greeting").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John!"));
    }
}

