/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;

public class DMNDecisionTableHitPolicyTest {
    @Test
    public void testSimpleDecisionTableHitPolicyUnique() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-U.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.is((Object)"Approved"));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUniqueSatisfies() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-U.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "ASD", false);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((dmnResult.getMessages().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUniqueNullWarn() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-U-noinputvalues.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U-noinputvalues");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "ASD", false);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((dmnResult.getMessages().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dmnResult.getMessages().stream().anyMatch(dm -> dm.getSeverity().equals((Object)DMNMessage.Severity.WARN) && dm.getFeelEvent() instanceof HitPolicyViolationEvent && dm.getFeelEvent().getSeverity().equals((Object)FEELEvent.Severity.WARN)));
    }

    @Test
    public void testDecisionTableHitPolicyUnique() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("BranchDistribution.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_cdf29af2-959b-4004-8271-82a9f5a62147", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Branches dispersion", (Object)"Province");
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Branches distribution"), (Matcher)CoreMatchers.is((Object)"Medium"));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyFirst() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-F.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-F");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Map decisionResult = (Map)result.get("Decision Result");
        Assert.assertThat(decisionResult.values(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Approval Status"), (Matcher)CoreMatchers.is((Object)"Approved")));
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Decision Review"), (Matcher)CoreMatchers.is((Object)"Decision final")));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyAnyEqualRules() {
        this.testSimpleDecisionTableHitPolicyAny("0004-simpletable-A.dmn", "0004-simpletable-A", true);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyAnyNonEqualRules() {
        this.testSimpleDecisionTableHitPolicyAny("0004-simpletable-A-non-equal.dmn", "0004-simpletable-A-non-equal", false);
    }

    private void testSimpleDecisionTableHitPolicyAny(String resurceName, String modelName, boolean equalRules) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(resurceName, this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", modelName);
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        if (equalRules) {
            Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.is((Object)"Approved"));
        } else {
            Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)((String)result.get("Approval Status")), (Matcher)Matchers.isEmptyOrNullString());
        }
    }

    @Test
    public void testSimpleDecisionTableHitPolicyPriority() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-P.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-P");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.is((Object)"Declined"));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyPriorityMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-P-multiple-outputs.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-P-multiple-outputs");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Map decisionResult = (Map)result.get("Decision Result");
        Assert.assertThat(decisionResult.values(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Approval Status"), (Matcher)CoreMatchers.is((Object)"Declined")));
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Decision Review"), (Matcher)CoreMatchers.is((Object)"Needs verification")));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyOutputOrder() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-O.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-O");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResults = (List)result.get("Approval Status");
        Assert.assertThat((Object)decisionResults, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)decisionResults, (Matcher)Matchers.contains((Object[])new String[]{"Declined", "Declined", "Approved"}));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyOutputOrderMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-O-multiple-outputs.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-O-multiple-outputs");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResult = (List)result.get("Decision Result");
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasSize((int)4));
        this.checkMultipleOutputResult((Map)decisionResult.get(0), "Declined", "Needs verification");
        this.checkMultipleOutputResult((Map)decisionResult.get(1), "Declined", "Decision final");
        this.checkMultipleOutputResult((Map)decisionResult.get(2), "Approved", "Needs verification");
        this.checkMultipleOutputResult((Map)decisionResult.get(3), "Approved", "Decision final");
    }

    private void checkMultipleOutputResult(Map<String, String> outputResult, String expectedApprovalStatus, String expectedDecisionReview) {
        Assert.assertThat(outputResult, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Approval Status"), (Matcher)CoreMatchers.is((Object)expectedApprovalStatus)));
        Assert.assertThat(outputResult, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Decision Review"), (Matcher)CoreMatchers.is((Object)expectedDecisionReview)));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyRuleOrder() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-R.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-R");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResults = (List)result.get("Approval Status");
        Assert.assertThat((Object)decisionResults, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)decisionResults, (Matcher)Matchers.contains((Object[])new String[]{"Approved", "Needs review", "Declined"}));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollect() {
        List<BigDecimal> decisionResults = this.executeTestDecisionTableHitPolicyCollect(this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
        Assert.assertThat(decisionResults, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(decisionResults, (Matcher)Matchers.contains((Object[])new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(25L), BigDecimal.valueOf(13L)}));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectNoHits() {
        List<BigDecimal> decisionResults = this.executeTestDecisionTableHitPolicyCollect(this.getSimpleTableContext(BigDecimal.valueOf(5L), "Medium", true));
        Assert.assertThat(decisionResults, (Matcher)Matchers.hasSize((int)0));
    }

    private List<BigDecimal> executeTestDecisionTableHitPolicyCollect(DMNContext context) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-C.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-C");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResults = (List)result.get("Status number");
        return decisionResults;
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectSum() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-sum.dmn", "0004-simpletable-C-sum", BigDecimal.valueOf(48L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectSumMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-C-sum-multiple-outputs.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-C-sum-multiple-outputs");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Map decisionResult = (Map)result.get("Decision Result");
        Assert.assertThat(decisionResult.values(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasEntry((Object)"Value1", (Object)BigDecimal.valueOf(25L)));
        Assert.assertThat((Object)decisionResult, (Matcher)Matchers.hasEntry((Object)"Value2", (Object)BigDecimal.valueOf(32L)));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectMin() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-min.dmn", "0004-simpletable-C-min", BigDecimal.valueOf(10L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectMax() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-max.dmn", "0004-simpletable-C-max", BigDecimal.valueOf(25L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectCount() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-count.dmn", "0004-simpletable-C-count", BigDecimal.valueOf(3L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectCountNoHits() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-count.dmn", "0004-simpletable-C-count", BigDecimal.valueOf(0L), this.getSimpleTableContext(BigDecimal.valueOf(5L), "Medium", true));
    }

    private void testSimpleDecisionTableHitPolicyCollectAggregateFunction(String resourceName, String modelName, BigDecimal expectedResult, DMNContext context) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(resourceName, this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", modelName);
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Assert.assertThat((Object)result.get("Status number"), (Matcher)CoreMatchers.is((Object)expectedResult));
    }

    private DMNContext evaluateSimpleTableWithContext(DMNModel model, DMNRuntime runtime, DMNContext context) {
        DMNResult dmnResult = runtime.evaluateAll(model, context);
        return dmnResult.getContext();
    }

    private DMNContext getSimpleTableContext(BigDecimal age, String riskCategory, boolean isAffordable) {
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)age);
        context.set("RiskCategory", (Object)riskCategory);
        context.set("isAffordable", (Object)isAffordable);
        return context;
    }

    @Test
    public void testDecisionTableHitPolicyCollect() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Collect_Hit_Policy.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_da1a4dcb-01bf-4dee-9be8-f498bc68178c", "Collect Hit Policy");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Input", (Object)20);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Collect"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(50L)));
    }
}

