/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.KieHelper;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public class DMNDecisionTableRuntimeTest {
    @Test
    public void testDecisionTableWithCalculatedResult() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("calculation1.dmn", this.getClass());
        this.checkDecisionTableWithCalculatedResult(runtime);
    }

    private void checkDecisionTableWithCalculatedResult(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_77ae284e-ce52-4579-a50f-f3cc584d7f4b", "Calculation1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("MonthlyDeptPmt", (Object)BigDecimal.valueOf(200L));
        context.set("MonthlyPmt", (Object)BigDecimal.valueOf(100L));
        context.set("MonthlyIncome", (Object)BigDecimal.valueOf(600L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)((BigDecimal)result.get("Logique de d\u00e9cision 1")).setScale(1, RoundingMode.CEILING), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(0.5)));
    }

    @Test(timeout=30000L)
    public void testDecisionTableWithCalculatedResult_parallel() throws Throwable {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("calculation1.dmn", this.getClass());
        Runnable task = () -> this.checkDecisionTableWithCalculatedResult(runtime);
        List problems = Collections.synchronizedList(new ArrayList());
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>();
        for (int i = 0; i < 10000; ++i) {
            CompletionStage newtask = CompletableFuture.runAsync(task).exceptionally(t -> {
                problems.add(t);
                return null;
            });
            tasks.add(newtask);
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).get();
        Iterator iterator = problems.iterator();
        if (iterator.hasNext()) {
            Throwable t2 = (Throwable)iterator.next();
            throw t2;
        }
    }

    @Test
    public void testDecisionTableMultipleResults() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("car_damage_responsibility.dmn", this.getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_820611e9-c21c-47cd-8e52-5cba2be9f9cc", "Car Damage Responsibility");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Membership Level", (Object)"Silver");
        context.set("Damage Types", (Object)"Body");
        context.set("Responsible", (Object)"Driver");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)((Map)result.get("Car Damage Responsibility")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"EU Rent"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(40L))));
        Assert.assertThat((Object)((Map)result.get("Car Damage Responsibility")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Renter"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(60L))));
        Assert.assertThat((Object)result.get("Payment method"), (Matcher)CoreMatchers.is((Object)"Check"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)captor.capture());
        AfterEvaluateDecisionTableEvent first = (AfterEvaluateDecisionTableEvent)captor.getAllValues().get(0);
        Assert.assertThat((Object)first.getMatches(), (Matcher)CoreMatchers.is(Collections.singletonList(5)));
        Assert.assertThat((Object)first.getSelected(), (Matcher)CoreMatchers.is(Collections.singletonList(5)));
        AfterEvaluateDecisionTableEvent second = (AfterEvaluateDecisionTableEvent)captor.getAllValues().get(1);
        Assert.assertThat((Object)second.getMatches(), (Matcher)CoreMatchers.is(Collections.singletonList(3)));
        Assert.assertThat((Object)second.getSelected(), (Matcher)CoreMatchers.is(Collections.singletonList(3)));
    }

    @Test
    public void testSimpleDecisionTableMultipleOutputWrongOutputType() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-simpletable-P-multiple-outputs-wrong-output.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-P-multiple-outputs-wrong-output");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)BigDecimal.valueOf(18L));
        context.set("RiskCategory", (Object)"Medium");
        context.set("isAffordable", (Object)true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().stream().filter(message -> message.getFeelEvent().getSourceException() instanceof NullPointerException).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testDecisionTableInvalidInputErrorMessage() {
        DMNContext context = DMNFactory.newContext();
        context.set("Branches dispersion", (Object)"Province");
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        this.testDecisionTableInvalidInput(context);
    }

    @Test
    public void testDecisionTableInvalidInputTypeErrorMessage() {
        DMNContext context = DMNFactory.newContext();
        context.set("Branches dispersion", (Object)1);
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        this.testDecisionTableInvalidInput(context);
    }

    @Test
    public void testDecisionTableNonexistingInputErrorMessage() {
        DMNContext context = DMNFactory.newContext();
        context.set("Not exists", (Object)"Province");
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        this.testDecisionTableInvalidInput(context);
    }

    private void testDecisionTableInvalidInput(DMNContext inputContext) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("InvalidInput.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_cdf29af2-959b-4004-8271-82a9f5a62147", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, inputContext);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.isDefined("Branches distribution"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testDecisionTableDefaultValue() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("decisiontable-default-value.dmn", this.getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "decisiontable-default-value");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)new BigDecimal(16));
        context.set("RiskCategory", (Object)"Medium");
        context.set("isAffordable", (Object)true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)dmnResult.getMessages().toString(), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.is((Object)"Declined"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener)).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)captor.capture());
        Assert.assertThat((Object)((AfterEvaluateDecisionTableEvent)captor.getValue()).getMatches(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)((AfterEvaluateDecisionTableEvent)captor.getValue()).getSelected(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testTwoDecisionTables() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("two_decision_tables.dmn", this.getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_bbb692e7-3d95-407a-bf39-353085bf57f0", "Invocation with two decision table as parameters");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Number", (Object)50);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)dmnResult.getMessages().toString(), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)((Map)result.get("Decision Logic 2")), (Matcher)Matchers.hasEntry((Object)"the 5 analysis", (Object)"A number greater than 5"));
        Assert.assertThat((Object)((Map)result.get("Decision Logic 2")), (Matcher)Matchers.hasEntry((Object)"the 100 analysis", (Object)"A number smaller than 100"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)captor.capture());
        Assert.assertThat((Object)((AfterEvaluateDecisionTableEvent)captor.getAllValues().get(0)).getDecisionTableName(), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)((AfterEvaluateDecisionTableEvent)captor.getAllValues().get(1)).getDecisionTableName(), (Matcher)CoreMatchers.is((Object)"b"));
    }

    @Test
    public void testDTInputExpressionLocalXmlnsInference() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("drools1502-InputExpression.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("MyDecision"), (Matcher)CoreMatchers.is((Object)"Decision taken"));
    }

    @Test
    public void testDTInContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DT_in_context.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_4acdcb25-b298-435e-abd5-efd00ed686a5", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("D1").getResult(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Map.class)));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat(((Map)result.get("D1")).get("Text color"), (Matcher)CoreMatchers.is((Object)"red"));
    }

    @Test
    public void testDTUsingEqualsUnaryTestWithVariable1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DT_using_variables.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ed1ec15b-40aa-424d-b1d0-4936df80b135", "DT Using variables");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        HashMap<String, Object> complex = new HashMap<String, Object>();
        complex.put("aBoolean", true);
        complex.put("aNumber", 10);
        complex.put("aString", "bar");
        DMNContext context = DMNFactory.newContext();
        context.set("Complex", complex);
        context.set("Another boolean", (Object)true);
        context.set("Another String", (Object)"bar");
        context.set("Another number", (Object)10);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Compare Boolean"), (Matcher)CoreMatchers.is((Object)"Same boolean"));
        Assert.assertThat((Object)result.get("Compare Number"), (Matcher)CoreMatchers.is((Object)"Equals"));
        Assert.assertThat((Object)result.get("Compare String"), (Matcher)CoreMatchers.is((Object)"Same String"));
    }

    @Test
    public void testDTUsingEqualsUnaryTestWithVariable2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DT_using_variables.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ed1ec15b-40aa-424d-b1d0-4936df80b135", "DT Using variables");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        HashMap<String, Object> complex = new HashMap<String, Object>();
        complex.put("aBoolean", true);
        complex.put("aNumber", 10);
        complex.put("aString", "bar");
        DMNContext context = DMNFactory.newContext();
        context.set("Complex", complex);
        context.set("Another boolean", (Object)false);
        context.set("Another String", (Object)"foo");
        context.set("Another number", (Object)20);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Compare Boolean"), (Matcher)CoreMatchers.is((Object)"Not same boolean"));
        Assert.assertThat((Object)result.get("Compare Number"), (Matcher)CoreMatchers.is((Object)"Bigger"));
        Assert.assertThat((Object)result.get("Compare String"), (Matcher)CoreMatchers.is((Object)"Different String"));
    }

    @Test
    public void testEmptyOutputCell() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DT_empty_output_cell.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_77ae284e-ce52-4579-a50f-f3cc584d7f4b", "Calculation1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("MonthlyDeptPmt", (Object)BigDecimal.valueOf(1L));
        context.set("MonthlyPmt", (Object)BigDecimal.valueOf(1L));
        context.set("MonthlyIncome", (Object)BigDecimal.valueOf(1L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertNull((Object)dmnResult.getContext().get("Logique de d\u00e9cision 1"));
    }

    @Test
    public void testNullRelation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("nullrelation.dmn", this.getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_946a2145-89ae-4197-88b4-40e6f88c8101", "Null in relations");
        Assert.assertThat((Object)model, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(model.getMessages()), (Object)model.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Value", (Object)"a3");
        DMNResult result = runtime.evaluateByName(model, context, new String[]{"Mapping"});
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(result.getMessages()), (Object)result.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollection() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionTableOutputDMNTypeCollection.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a decision"), (Matcher)CoreMatchers.is(Arrays.asList("abc", "xyz")));
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollection_NOtypecheck() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("DecisionTableOutputDMNTypeCollection.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a decision"), (Matcher)CoreMatchers.is(Arrays.asList("abc", "xyz")));
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollectionWithLOV() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionTableOutputDMNTypeCollectionWithLOV.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "List of Words in DT");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a decision"), (Matcher)CoreMatchers.is(Arrays.asList("abc", "a")));
    }

    @Test
    public void testDecisionTableOutputDMNTypeCollectionWithLOV_NOtypecheck() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("DecisionTableOutputDMNTypeCollectionWithLOV.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ae5d2033-c6d0-411f-a394-da33a70e5638", "List of Words in DT");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("selector", (Object)"asd");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a decision"), (Matcher)CoreMatchers.is(Arrays.asList("abc", "a")));
    }

    @Test
    public void testDecisionTablesQuestionMarkVariableCorrectEvaluation() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmark.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkAsString() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkAsString.dmn", "NOT OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkAsString2.dmn", "NOT OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkAsString3.dmn", "NOT OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkVariableVsQuestionMarkString() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkVsQmarkString.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkOnly() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkonly.dmn", null, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
    }

    @Test
    public void testDecisionTablesQuestionMarkMultivalue() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkMultivalue.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkMultivalueWithBrackets() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkMultivalueWithBrackets.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithNot() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithNot.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithContext() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithContext.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithQuantifiedExpression() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithQuantifiedExpr.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithForExpression() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithForExpr.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithFuncDef() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithFuncDef.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkInstanceOf() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkInstanceOf.dmn", "NOT OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkInWithUnaryTests() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkInWithUnaryTest.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithRange() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithRange.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkWithAnd() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkWithAnd.dmn", "OK", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
    }

    @Test
    public void testDecisionTablesQuestionMarkInNonBooleanFunction() {
        this.testDecisionTablesQuestionMarkVariable("questionmarkunarytest/qmarkInNonBooleanFunction.dmn", null, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
    }

    private void testDecisionTablesQuestionMarkVariable(String dmnResourcePath, String expectedResult, DMNDecisionResult.DecisionEvaluationStatus expectedStatus) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(dmnResourcePath, this.getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_88a36f38-4494-4fd8-aaea-f7a6b4c91825", "Enabling question marks");
        Assert.assertThat((Object)model, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(model.getMessages()), (Object)model.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        DMNDecisionResult result = runtime.evaluateByName(model, context, new String[]{"Result"}).getDecisionResultByName("Result");
        Assert.assertEquals((Object)expectedStatus, (Object)result.getEvaluationStatus());
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((Object)expectedResult, (Object)result.getResult());
    }
}

