/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNUnaryTest;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;

public class DMNInputRuntimeTest {
    @Test
    public void testInputStringEvaluateAll() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void testInputStringEvaluateDecisionByName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{"Greeting Message"});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{"nonExistantName"});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{""});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{null});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
    }

    @Test
    public void testInputStringEvaluateDecisionById() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateById(dmnModel, context, new String[]{"d_GreetingMessage"});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultById("d_GreetingMessage").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        dmnResult = runtime.evaluateById(dmnModel, context, new String[]{"nonExistantId"});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = runtime.evaluateById(dmnModel, context, new String[]{""});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
        dmnResult = runtime.evaluateById(dmnModel, context, new String[]{null});
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED));
    }

    @Test
    public void testInputStringAllowedValuesEvaluateAll() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0003-input-data-string-allowed-values.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0003-input-data-string-allowed-values");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Employment Status", (Object)"SELF-EMPLOYED");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Employment Status Statement"), (Matcher)CoreMatchers.is((Object)"You are SELF-EMPLOYED"));
    }

    @Test
    public void testInputStringNotInTypeScopeEvaluateAll() {
        this.testInputStringNotAllowedValuesEvaluateAll("NOT-ALLOWED-VALUE");
    }

    @Test
    public void testInputStringWrongTypeEvaluateAll() {
        this.testInputStringNotAllowedValuesEvaluateAll(new Object());
    }

    public void testInputStringNotAllowedValuesEvaluateAll(Object inputValue) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0003-input-data-string-allowed-values.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0003-input-data-string-allowed-values");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Employment Status", inputValue);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Employment Status Statement").getResult(), (Matcher)CoreMatchers.is((Object)null));
        Assert.assertThat((Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(0)).getSeverity(), (Matcher)CoreMatchers.is((Object)DMNMessage.Severity.ERROR));
        Assert.assertThat((Object)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages().get(0)).getSeverity(), (Matcher)CoreMatchers.is((Object)DMNMessage.Severity.ERROR));
    }

    @Test
    public void testInputNumberEvaluateAll() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0002-input-data-number.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0002-input-data-number");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Monthly Salary", (Object)new BigDecimal(1000));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Yearly Salary"), (Matcher)CoreMatchers.is((Object)new BigDecimal(12000)));
    }

    @Test
    public void testGetRequiredInputsByName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Set inputs = dmnModel.getRequiredInputsForDecisionName("Greeting Message");
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((InputDataNode)inputs.iterator().next()).getName(), (Matcher)CoreMatchers.is((Object)"Full Name"));
        inputs = dmnModel.getRequiredInputsForDecisionName("nonExistantDecisionName");
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testGetRequiredInputsById() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Set inputs = dmnModel.getRequiredInputsForDecisionId("d_GreetingMessage");
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((InputDataNode)inputs.iterator().next()).getName(), (Matcher)CoreMatchers.is((Object)"Full Name"));
        inputs = dmnModel.getRequiredInputsForDecisionId("nonExistantId");
        Assert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testNonexistantInputNodeName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Nonexistant Input", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)null));
        Assert.assertThat((Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(0)).getSeverity(), (Matcher)CoreMatchers.is((Object)DMNMessage.Severity.ERROR));
        Assert.assertThat((Object)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages().get(0)).getSeverity(), (Matcher)CoreMatchers.is((Object)DMNMessage.Severity.ERROR));
    }

    @Test
    public void testAllowedValuesChecks() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("AllowedValuesChecks.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_238bd96d-47cd-4746-831b-504f3e77b442", "AllowedValuesChecks");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx1 = runtime.newContext();
        ctx1.set("p1", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Name", "P1"), DynamicTypeUtils.entry("Interests", Arrays.asList("Golf"))));
        DMNResult dmnResult1 = runtime.evaluateAll(dmnModel, ctx1);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult1.getMessages()), (Object)dmnResult1.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult1.getContext().get("MyDecision"), (Matcher)CoreMatchers.is((Object)"The Person P1 likes 1 thing(s)."));
        DMNContext ctx2 = runtime.newContext();
        ctx2.set("p1", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Name", "P2"), DynamicTypeUtils.entry("Interests", Arrays.asList("x"))));
        DMNResult dmnResult2 = runtime.evaluateAll(dmnModel, ctx2);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult2.getMessages()), (Object)dmnResult2.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult2.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.ERROR_EVAL_NODE)), (Matcher)CoreMatchers.is((Object)true));
        DMNContext ctx3 = runtime.newContext();
        ctx3.set("p1", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Name", "P3"), DynamicTypeUtils.entry("Interests", Arrays.asList("Golf", "Computer"))));
        DMNResult dmnResult3 = runtime.evaluateAll(dmnModel, ctx3);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult3.getMessages()), (Object)dmnResult3.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult3.getContext().get("MyDecision"), (Matcher)CoreMatchers.is((Object)"The Person P3 likes 2 thing(s)."));
        DMNContext ctx4 = runtime.newContext();
        ctx4.set("p1", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Name", "P4"), DynamicTypeUtils.entry("Interests", Arrays.asList("Golf", "x"))));
        DMNResult dmnResult4 = runtime.evaluateAll(dmnModel, ctx4);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult4.getMessages()), (Object)dmnResult4.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult4.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.ERROR_EVAL_NODE)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDMNInputDataNodeTypeTest() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DMNInputDataNodeTypeTest.dmn", this.getClass());
        String MODEL_NAMESPACE = "http://www.trisotech.com/definitions/_17396034-163a-48aa-9a7f-c6eb17f9cc6c";
        String FEEL_NAMESPACE = "http://www.omg.org/spec/FEEL/20140401";
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_17396034-163a-48aa-9a7f-c6eb17f9cc6c", "DMNInputDataNodeTypeTest");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        InputDataNode idnMembership = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Membership Level")).findFirst().get();
        Assert.assertThat((Object)idnMembership.getType().getBaseType().getNamespace(), (Matcher)CoreMatchers.is((Object)"http://www.omg.org/spec/FEEL/20140401"));
        Assert.assertThat((Object)idnMembership.getType().getBaseType().getName(), (Matcher)CoreMatchers.is((Object)"string"));
        Assert.assertThat((Object)idnMembership.getType().isCollection(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)idnMembership.getType().isComposite(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)idnMembership.getType().getAllowedValues().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((DMNUnaryTest)idnMembership.getType().getAllowedValues().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"\"Gold\""));
        Assert.assertThat((Object)((DMNUnaryTest)idnMembership.getType().getAllowedValues().get(1)).toString(), (Matcher)CoreMatchers.is((Object)"\"Silver\""));
        Assert.assertThat((Object)((DMNUnaryTest)idnMembership.getType().getAllowedValues().get(2)).toString(), (Matcher)CoreMatchers.is((Object)"\"None\""));
        InputDataNode idnMembershipLevels = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Membership Levels")).findFirst().get();
        Assert.assertThat((Object)idnMembershipLevels.getType().getBaseType().getNamespace(), (Matcher)CoreMatchers.is((Object)"http://www.trisotech.com/definitions/_17396034-163a-48aa-9a7f-c6eb17f9cc6c"));
        Assert.assertThat((Object)idnMembershipLevels.getType().getBaseType().getName(), (Matcher)CoreMatchers.is((Object)"tMembershipLevel"));
        Assert.assertThat((Object)idnMembershipLevels.getType().isCollection(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)idnMembershipLevels.getType().isComposite(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)idnMembershipLevels.getType().getAllowedValues().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        InputDataNode idnPercent = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Percent")).findFirst().get();
        Assert.assertThat((Object)idnPercent.getType().getBaseType().getNamespace(), (Matcher)CoreMatchers.is((Object)"http://www.omg.org/spec/FEEL/20140401"));
        Assert.assertThat((Object)idnPercent.getType().getBaseType().getName(), (Matcher)CoreMatchers.is((Object)"number"));
        Assert.assertThat((Object)idnPercent.getType().isCollection(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)idnPercent.getType().isComposite(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)idnPercent.getType().getAllowedValues().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNUnaryTest)idnPercent.getType().getAllowedValues().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"[0..100]"));
        InputDataNode idnCarDamageResponsibility = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Car Damage Responsibility")).findFirst().get();
        Assert.assertThat((Object)idnCarDamageResponsibility.getType().getBaseType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)idnCarDamageResponsibility.getType().isCollection(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)idnCarDamageResponsibility.getType().isComposite(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInputClauseTypeRefWithAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("actualInputMatchInputValues-forTypeRef.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("MyDecision"), (Matcher)CoreMatchers.is((Object)"Decision taken"));
    }

    @Test
    public void testInputDataTypeRefWithAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("actualInputMatchInputValues-forTypeRef.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"zzz");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(0)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_3d560678-a126-4654-a686-bc6d941fe40b"));
    }

    @Test
    public void testMissingInputData() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("missing_input_data.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_4047acf3-fce2-42f3-abf2-fb06282c1ea0", "Upgrade Based On Promotions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.ERR_COMPILING_FEEL));
    }
}

