/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.marshaller.FEELStringMarshaller;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.ItemDefinition;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNRuntimeTest.class);

    @Test
    public void testSimpleItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("simple-item-def.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn/itemdef", "simple-item-def");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Monthly Salary", (Object)1000);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Yearly Salary"), (Matcher)CoreMatchers.is((Object)new BigDecimal("12000")));
    }

    @Test
    public void testCompositeItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0008-LX-arithmetic.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0008-LX-arithmetic");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Number> loan = new HashMap<String, Number>();
        loan.put("principal", 600000);
        loan.put("rate", 0.0375);
        loan.put("termMonths", 360);
        context.set("loan", loan);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("payment"), (Matcher)CoreMatchers.is((Object)new BigDecimal("2778.693549432766768088520383236299")));
    }

    @Test
    public void testTrisotechNamespace() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("trisotech_namespace.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b8feec86-dadf-4051-9feb-8e6093bbb530", "Solution 3");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("IsDoubleHulled", (Object)true);
        context.set("Residual Cargo Size", (Object)BigDecimal.valueOf(0.1));
        context.set("Ship Size", (Object)new BigDecimal(50));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Ship can enter a Dutch port"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEmptyDecision1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("empty_decision.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ba9fc4b1-5ced-4d00-9b61-290de4bf3213", "Solution 3");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Comparable<BigDecimal>> shipInfo = new HashMap<String, Comparable<BigDecimal>>();
        shipInfo.put("Size", BigDecimal.valueOf(70L));
        shipInfo.put("Is Double Hulled", Boolean.FALSE);
        shipInfo.put("Residual Cargo Size", BigDecimal.valueOf(0.1));
        context.set("Ship Info", shipInfo);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Ship Can Enter v2"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEmptyDecision2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("empty_decision.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ba9fc4b1-5ced-4d00-9b61-290de4bf3213", "Solution 3");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Comparable<BigDecimal>> shipInfo = new HashMap<String, Comparable<BigDecimal>>();
        shipInfo.put("Size", BigDecimal.valueOf(70L));
        shipInfo.put("Is Double Hulled", Boolean.FALSE);
        shipInfo.put("Residual Cargo Size", BigDecimal.valueOf(0.1));
        context.set("Ship Info", shipInfo);
        context.set("Ship Size", (Object)BigDecimal.valueOf(70L));
        context.set("IsDoubleHulled", (Object)Boolean.FALSE);
        context.set("Residual Cargo Size", (Object)BigDecimal.valueOf(0.1));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        List messages = dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.WARN});
        Assert.assertThat((Object)messages.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)messages.get(0)).getSeverity(), (Matcher)CoreMatchers.is((Object)DMNMessage.Severity.WARN));
        Assert.assertThat((Object)((DMNMessage)messages.get(0)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_42806504-8ed5-488f-b274-de98c1bc67b9"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Ship Can Enter v2"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testEventListeners() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("car_damage_responsibility.dmn", this.getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_820611e9-c21c-47cd-8e52-5cba2be9f9cc", "Car Damage Responsibility");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Membership Level", (Object)"Silver");
        context.set("Damage Types", (Object)"Body");
        context.set("Responsible", (Object)"Driver");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).beforeEvaluateDecision((BeforeEvaluateDecisionEvent)Matchers.any(BeforeEvaluateDecisionEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecision((AfterEvaluateDecisionEvent)Matchers.any(AfterEvaluateDecisionEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).beforeEvaluateDecisionTable((BeforeEvaluateDecisionTableEvent)Matchers.any(BeforeEvaluateDecisionTableEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)argument.capture());
        AfterEvaluateDecisionTableEvent dte = (AfterEvaluateDecisionTableEvent)argument.getAllValues().get(0);
        Assert.assertThat((Object)dte.getDecisionTableName(), (Matcher)CoreMatchers.is((Object)"Car Damage Responsibility"));
        Assert.assertThat((Object)dte.getMatches(), (Matcher)CoreMatchers.is(Arrays.asList(5)));
        dte = (AfterEvaluateDecisionTableEvent)argument.getAllValues().get(1);
        Assert.assertThat((Object)dte.getDecisionTableName(), (Matcher)CoreMatchers.is((Object)"Payment method"));
        Assert.assertThat((Object)dte.getMatches(), (Matcher)CoreMatchers.is(Arrays.asList(3)));
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)((Map)result.get("Car Damage Responsibility")), (Matcher)org.hamcrest.Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"EU Rent"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(40L))));
        Assert.assertThat((Object)((Map)result.get("Car Damage Responsibility")), (Matcher)org.hamcrest.Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Renter"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(60L))));
        Assert.assertThat((Object)result.get("Payment method"), (Matcher)CoreMatchers.is((Object)"Check"));
    }

    @Test
    public void testErrorMessages() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("car_damage_responsibility2.dmn", this.getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_dcc63ab0-3a53-4628-8bee-3ae1f1ad683b", "Car Damage Responsibility");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testOutputReuse() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Input_reuse_in_output.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_098bb607-eff7-4772-83ac-6ded8b371fa7", "Input reuse in output");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)40);
        context.set("Requested Product", (Object)"Fixed30");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("My Decision"), (Matcher)CoreMatchers.is((Object)"Fixed30"));
    }

    @Test
    public void testSimpleNot() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Simple_Not.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_98436ebb-7c42-48c0-8d11-d693e2a817c9", "Simple Not");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Occupation", (Object)"Student");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a"), (Matcher)CoreMatchers.is((Object)"Is Student"));
    }

    @Test
    public void testSimpleNot2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Simple_Not.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_98436ebb-7c42-48c0-8d11-d693e2a817c9", "Simple Not");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Occupation", (Object)"Engineer");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a"), (Matcher)CoreMatchers.is((Object)"Is not a Student"));
    }

    @Test
    public void testDinner() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Dinner.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_0c45df24-0d57-4acc-b296-b4cba8b71a36", "Dinner");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Guests with children", (Object)true);
        context.set("Season", (Object)"Fall");
        context.set("Number of guests", (Object)4);
        context.set("Temp", (Object)25);
        context.set("Rain Probability", (Object)30);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getContext().get("Where to eat"), (Matcher)CoreMatchers.is((Object)"Outside"));
        Assert.assertThat((Object)dmnResult.getContext().get("Dish"), (Matcher)CoreMatchers.is((Object)"Spareribs"));
        Assert.assertThat((Object)dmnResult.getContext().get("Drinks"), (Matcher)CoreMatchers.is(Arrays.asList("Apero", "Ale", "Juice Boxes")));
    }

    @Test
    public void testNotificationsApproved2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("NotificationsTest2.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "building-structure-rules");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("existingActivityApplicability", (Object)true);
        context.set("Distance", (Object)new BigDecimal(9999));
        context.set("willIncreaseTraffic", (Object)true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Notification Status"), (Matcher)CoreMatchers.is((Object)"Notification to Province Approved"));
        Assert.assertThat((Object)result.get("Permit Status"), (Matcher)CoreMatchers.is((Object)"Building Activity Province Permit Required"));
    }

    @Test
    public void testBoxedContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("BoxedContext.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_0de36357-fec0-4b4e-b7f1-382d381e06e9", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a", (Object)10);
        context.set("b", (Object)5);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)dmnResult.getContext().get("Math")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
        Assert.assertThat((Object)((Map)dmnResult.getContext().get("Math")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"Product", (Object)BigDecimal.valueOf(50L)));
    }

    @Test
    public void testFunctionDefAndInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("FunctionDefinition.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_0de36357-fec0-4b4e-b7f1-382d381e06e9", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a", (Object)10);
        context.set("b", (Object)5);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)dmnResult.getContext().get("Math")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L)));
    }

    @Test
    public void testBuiltInFunctionInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("BuiltInFunctionInvocation.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b77219ee-ec28-48e3-b240-8e0dbbabefeb", "built in function invocation");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a", (Object)10);
        context.set("b", (Object)5);
        context.set("x", (Object)"Hello, World!");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getContext().get("calc min"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(5L)));
        Assert.assertThat((Object)dmnResult.getContext().get("fixed params"), (Matcher)CoreMatchers.is((Object)"World!"));
        Assert.assertThat((Object)dmnResult.getContext().get("out of order"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(5L)));
    }

    @Test
    public void testBKMNode() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0009-invocation-arithmetic.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_cb28c255-91cd-4c01-ac7b-1a9cb1ecdb11", "literal invocation1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        HashMap<String, BigDecimal> loan = new HashMap<String, BigDecimal>();
        loan.put("amount", BigDecimal.valueOf(600000L));
        loan.put("rate", new BigDecimal("0.0375"));
        loan.put("term", BigDecimal.valueOf(360L));
        DMNContext context = DMNFactory.newContext();
        context.set("fee", (Object)100);
        context.set("Loan", loan);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((BigDecimal)dmnResult.getContext().get("MonthlyPayment")).setScale(8, 1), (Matcher)CoreMatchers.is((Object)new BigDecimal("2878.69354943277").setScale(8, 1)));
    }

    @Test
    public void testItemDefCollection() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-filter.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_f52ca843-504b-4c3b-a6bc-4d377bffef7a", "filter01");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Object[][] data = new Object[][]{{1, "Finances", "John"}, {2, "Engineering", "Mary"}, {3, "Sales", "Kevin"}};
        ArrayList employees = new ArrayList();
        for (int i = 0; i < data.length; ++i) {
            HashMap<String, Object> e = new HashMap<String, Object>();
            e.put("id", data[i][0]);
            e.put("dept", data[i][1]);
            e.put("name", data[i][2]);
            employees.add(e);
        }
        DMNContext context = DMNFactory.newContext();
        context.set("Employee", employees);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getContext().get("filter01"), (Matcher)CoreMatchers.is(Arrays.asList("Mary")));
    }

    @Test
    public void testList() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("list-expression.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "list-expression");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getContext().get("Name list"), (Matcher)CoreMatchers.is(Arrays.asList("John", "Mary")));
    }

    @Test
    public void testRelation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("relation-expression.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "relation-expression");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)dmnModel.getMessages().toString(), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getContext().get("Employee Relation"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        List employees = (List)dmnResult.getContext().get("Employee Relation");
        Map e = (Map)employees.get(0);
        Assert.assertThat(e.get("Name"), (Matcher)CoreMatchers.is((Object)"John"));
        Assert.assertThat(e.get("Dept"), (Matcher)CoreMatchers.is((Object)"Sales"));
        Assert.assertThat(e.get("Salary"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(100000L)));
        e = (Map)employees.get(1);
        Assert.assertThat(e.get("Name"), (Matcher)CoreMatchers.is((Object)"Mary"));
        Assert.assertThat(e.get("Dept"), (Matcher)CoreMatchers.is((Object)"Finances"));
        Assert.assertThat(e.get("Salary"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(120000L)));
    }

    @Test
    public void testLendingExample() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-lending.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_4e0f0b70-d31c-471c-bd52-5ca709ed362b", "Lending1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Object> applicant = new HashMap<String, Object>();
        HashMap<String, Integer> monthly = new HashMap<String, Integer>();
        monthly.put("Income", 6000);
        monthly.put("Expenses", 2000);
        monthly.put("Repayments", 0);
        applicant.put("Monthly", monthly);
        applicant.put("Age", 35);
        applicant.put("ExistingCustomer", true);
        applicant.put("MaritalStatus", "M");
        applicant.put("EmploymentStatus", "EMPLOYED");
        HashMap<String, Object> product = new HashMap<String, Object>();
        product.put("ProductType", "STANDARD LOAN");
        product.put("Amount", 350000);
        product.put("Rate", new BigDecimal("0.0395"));
        product.put("Term", 360);
        HashMap<String, Constable> bureau = new HashMap<String, Constable>();
        bureau.put("CreditScore", Integer.valueOf(649));
        bureau.put("Bankrupt", Boolean.valueOf(false));
        context.set("ApplicantData", applicant);
        context.set("RequestedProduct", product);
        context.set("BureauData", bureau);
        context.set("SupportingDocuments", (Object)"yes");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext ctx = dmnResult.getContext();
        Assert.assertThat((Object)ctx.get("ApplicationRiskScore"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(130L)));
        Assert.assertThat((Object)ctx.get("Pre-bureauRiskCategory"), (Matcher)CoreMatchers.is((Object)"LOW"));
        Assert.assertThat((Object)ctx.get("BureauCallType"), (Matcher)CoreMatchers.is((Object)"MINI"));
        Assert.assertThat((Object)ctx.get("Post-bureauRiskCategory"), (Matcher)CoreMatchers.is((Object)"LOW"));
        Assert.assertThat((Object)((BigDecimal)ctx.get("RequiredMonthlyInstallment")).setScale(5, 1), (Matcher)CoreMatchers.is((Object)new BigDecimal("1680.880325608555").setScale(5, 1)));
        Assert.assertThat((Object)ctx.get("Pre-bureauAffordability"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ctx.get("Eligibility"), (Matcher)CoreMatchers.is((Object)"ELIGIBLE"));
        Assert.assertThat((Object)ctx.get("Strategy"), (Matcher)CoreMatchers.is((Object)"BUREAU"));
        Assert.assertThat((Object)ctx.get("Post-bureauAffordability"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)ctx.get("Routing"), (Matcher)CoreMatchers.is((Object)"ACCEPT"));
    }

    @Test
    public void testDateAndTime() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0007-date-time.dmn", this.getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_69430b3e-17b8-430d-b760-c505bf6469f9", "dateTime Table 58");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("dateString", (Object)"2015-12-24");
        context.set("timeString", (Object)"00:00:01-01:00");
        context.set("dateTimeString", (Object)"2016-12-24T23:59:00-05:00");
        context.set("Hours", (Object)12);
        context.set("Minutes", (Object)59);
        context.set("Seconds", (Object)new BigDecimal("1.3"));
        context.set("Timezone", (Object)"PT-1H");
        context.set("Year", (Object)1999);
        context.set("Month", (Object)11);
        context.set("Day", (Object)22);
        context.set("oneHour", (Object)Duration.parse("PT1H"));
        context.set("durationString", (Object)"P13DT2H14S");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext ctx = dmnResult.getContext();
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ctx.get("Date-Time"), (Matcher)CoreMatchers.is((Object)ZonedDateTime.of(2016, 12, 24, 23, 59, 0, 0, ZoneOffset.ofHours(-5))));
        Assert.assertThat((Object)ctx.get("Date"), (Matcher)CoreMatchers.is((Object)new HashMap<String, Object>(){
            {
                this.put("fromString", LocalDate.of(2015, 12, 24));
                this.put("fromDateTime", LocalDate.of(2016, 12, 24));
                this.put("fromYearMonthDay", LocalDate.of(1999, 11, 22));
            }
        }));
        Assert.assertThat((Object)ctx.get("Time"), (Matcher)CoreMatchers.is((Object)OffsetTime.of(0, 0, 1, 0, ZoneOffset.ofHours(-1))));
        Assert.assertThat((Object)ctx.get("Date-Time2"), (Matcher)CoreMatchers.is((Object)ZonedDateTime.of(2015, 12, 24, 0, 0, 1, 0, ZoneOffset.ofHours(-1))));
        Assert.assertThat((Object)ctx.get("Time2"), (Matcher)CoreMatchers.is((Object)OffsetTime.of(0, 0, 1, 0, ZoneOffset.ofHours(-1))));
        Assert.assertThat((Object)ctx.get("Time3"), (Matcher)CoreMatchers.is((Object)OffsetTime.of(12, 59, 1, 300000000, ZoneOffset.ofHours(-1))));
        Assert.assertThat((Object)ctx.get("dtDuration1"), (Matcher)CoreMatchers.is((Object)Duration.parse("P13DT2H14S")));
        Assert.assertThat((Object)ctx.get("dtDuration2"), (Matcher)CoreMatchers.is((Object)Duration.parse("P367DT3H58M59S")));
        Assert.assertThat((Object)ctx.get("hoursInDuration"), (Matcher)CoreMatchers.is((Object)new BigDecimal("3")));
        Assert.assertThat((Object)ctx.get("sumDurations"), (Matcher)CoreMatchers.is((Object)Duration.parse("PT9125H59M13S")));
        Assert.assertThat((Object)ctx.get("ymDuration2"), (Matcher)CoreMatchers.is((Object)Period.parse("P1Y")));
        Assert.assertThat((Object)ctx.get("cDay"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(24L)));
        Assert.assertThat((Object)ctx.get("cYear"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2015L)));
        Assert.assertThat((Object)ctx.get("cMonth"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(12L)));
        Assert.assertThat((Object)ctx.get("cHour"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(0L)));
        Assert.assertThat((Object)ctx.get("cMinute"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(0L)));
        Assert.assertThat((Object)ctx.get("cSecond"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)ctx.get("cTimezone"), (Matcher)CoreMatchers.is((Object)"GMT-01:00"));
        Assert.assertThat((Object)ctx.get("years"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)ctx.get("seconds"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(14L)));
    }

    @Test
    public void testFiltering() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Person_filtering_by_age.dmn", this.getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_e215ed7a-701b-4c53-b8df-4b4d23d5fe32", "Person filtering by age");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Min Age", (Object)50);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)((List)dmnResult.getContext().get("Filtering")).size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testNowFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("today_function_test.dmn", this.getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_4ad80959-5fd8-46b7-8c9a-ab2fa58cb5b4", "When is it");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("The date", (Object)LocalDate.of(2017, 1, 12));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.getContext().get("When is it"), (Matcher)CoreMatchers.is((Object)"It is in the past"));
    }

    @Test
    public void testTimeFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("TimeFromDate.dmn", this.getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("datetimestring", (Object)"2016-07-29T05:48:23");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.getContext().get("time"), (Matcher)CoreMatchers.is((Object)LocalTime.of(5, 48, 23)));
    }

    @Test
    public void testAlternativeNSDecl() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("alternative_feel_ns_declaration.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void testLoanComparison() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("loanComparison.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_3a1fd8f4-ea04-4453-aa30-ff14140e3441", "loanComparison");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("RequestedAmt", (Object)500000);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetViableLoanProducts() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Get_Viable_Loan_Products.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_3e1a628d-36bc-45f1-8464-b201735e5ce0", "Get Viable Loan Products");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        HashMap<String, Object> requested = new HashMap<String, Object>();
        requested.put("PropertyZIP", "91001");
        requested.put("LoanAmt", 300000);
        requested.put("Objective", "Payment");
        requested.put("DownPct", new BigDecimal("0.4"));
        requested.put("MortgageType", "Fixed 20");
        DMNContext context = DMNFactory.newContext();
        context.set("Requested", requested);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("isConforming"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Collection)result.get("LoanTypes")), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
    }

    @Test
    public void testYearsAndMonthsDuration() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("yearMonthDuration.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_6eda1490-21ca-441e-8a26-ab3ca800e43c", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        BuiltInType feelType = (BuiltInType)BuiltInType.determineTypeFromName((String)"yearMonthDuration");
        Period period = (Period)feelType.fromString("P2Y1M");
        DMNContext context = runtime.newContext();
        context.set("iDuration", (Object)period);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("How long"), (Matcher)CoreMatchers.is((Object)"Longer than a year"));
    }

    @Test
    public void testInvalidVariableNames() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("invalid-variable-names.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testNull() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("null_values.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "Null values model");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Null Input", null);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Null value"), (Matcher)CoreMatchers.is((Object)"Input is null"));
        context = runtime.newContext();
        context.set("Null Input", (Object)"foo");
        dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Null value"), (Matcher)CoreMatchers.is((Object)"Input is not null"));
    }

    @Test
    @Ignore
    public void testInvalidUHitPolicy() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Invalid_U_hit_policy.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_7cf49108-9b55-4f35-b5ef-f83448061757", "Greater than 5 - Invalid U hit policy");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Number", (Object)5);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(0)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_c5eda7c3-7f22-43c2-8c1e-a3cc79bb7a74"));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(1)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_5bac3e4c-b59a-4f14-b5cf-d4d88c60877f"));
    }

    @Test
    public void testInvalidModel() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Loan_Prequalification_Condensed_Invalid.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ba68fb9d-7421-4f3a-a7ab-f785ea0bae6b", "Loan Prequalification Condensed");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_8b5cac9e-c8ca-4817-b05a-c70fa79a8d48"));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(1)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_ef09d90e-e1a4-4ec9-885b-482d1f4a1cee"));
    }

    @Test
    public void testNullOnNumber() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Number_and_null_entry.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_a293b9f9-c912-41ee-8147-eae59ba86ac5", "Number and null entry");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("num", null);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decision Logic 1"), (Matcher)CoreMatchers.is((Object)"Null"));
        context = runtime.newContext();
        context.set("num", (Object)4);
        dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decision Logic 1"), (Matcher)CoreMatchers.is((Object)"Positive number"));
    }

    @Test
    public void testLoan_Recommendation2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Loan_Recommendation2.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_35c7339b-b868-43da-8f06-eb481708c73c", "Loan Recommendation2");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        HashMap<String, Number> loan = new HashMap<String, Number>();
        loan.put("Amount", 100000);
        loan.put("Rate", 2.39);
        loan.put("Term", 60);
        HashMap<String, Object> borrower = new HashMap<String, Object>();
        borrower.put("Age", 39);
        borrower.put("EmploymentStatus", "Employed");
        borrower.put("YearsAtCurrentEmployer", 10);
        borrower.put("TotalAnnualIncome", 150000);
        borrower.put("NonSalaryIncome", 0);
        borrower.put("MonthlyDebtPmtAmt", 2000);
        borrower.put("LiquidAssetsAmt", 50000);
        DMNContext context = runtime.newContext();
        context.set("Credit Score", null);
        context.set("Appraised Value", (Object)200000);
        context.set("Loan", loan);
        context.set("Borrower", borrower);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Loan Recommendation"), (Matcher)CoreMatchers.is((Object)"Decline"));
    }

    @Test
    public void testPriority_table() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("priority_table.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ff54a44d-b8f5-48fc-b2b7-43db767e8a1c", "not quite all or nothing P");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("isAffordable", (Object)false);
        context.set("RiskCategory", (Object)"Medium");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.is((Object)"Declined"));
    }

    @Test
    public void testPriority_table_context_recursion() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("priority_table_context_recursion.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ff54a44d-b8f5-48fc-b2b7-43db767e8a1c", "not quite all or nothing P");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("isAffordable", (Object)false);
        context.set("RiskCategory", (Object)"Medium");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Approval Status"), (Matcher)CoreMatchers.is((Object)"Declined"));
    }

    @Test
    public void testPriority_table_missing_output_values() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DTABLE_PRIORITY_MISSING_OUTVALS.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_MISSING_OUTVALS");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void test_non_Priority_table_missing_output_values() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DTABLE_NON_PRIORITY_MISSING_OUTVALS.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "DTABLE_NON_PRIORITY_MISSING_OUTVALS");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testPriority_table_one_output_value() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DTABLE_PRIORITY_ONE_OUTVAL.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_ONE_OUTVAL");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testNoPrefix() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("drools1502-noprefix.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("MyDecision"), (Matcher)CoreMatchers.is((Object)"Decision taken"));
    }

    @Test
    public void testWrongConstraintsInItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("WrongConstraintsInItemDefinition.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_81d8fefe-9cd7-43b8-922a-ff245c434457", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getSourceReference(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ItemDefinition.class)));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.ERR_COMPILING_FEEL));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(1)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_e794c655-4fdf-45d1-b7b7-d990df513f92"));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(1)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.ERR_COMPILING_FEEL));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(2)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_31911de7-e184-411c-99d1-f33977971270"));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(2)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_TYPE_REF));
    }

    @Test
    public void testResolutionOfVariableWithLeadingOrTrailingSpaces() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("variableLeadingTrailingSpaces.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("Name", "John");
        person.put("Surname", "Doe");
        context.set("Input Person", person);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Further Decision"), (Matcher)CoreMatchers.is((Object)"The person was greeted with: 'Ciao John Doe'"));
    }

    @Test
    public void testOutOfOrderItemsNPE() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("out-of-order-items.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "out-of-order");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.FAILED_VALIDATOR)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testItemDefDependencies() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("itemDef-dependency.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_2374ee6d-75ed-4e9d-95d3-a88c135e1c43", "Drawing 1a");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("Full Name", "John Doe");
        person.put("Address", "100 East Davie Street");
        context.set("Input Person", person);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("My Decision"), (Matcher)CoreMatchers.is((Object)"The person John Doe is located at 100 East Davie Street"));
    }

    @Test
    public void testDecisionResultTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("LoanRecommendationWrongOutputType.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_591d49d0-26e1-4a1c-9f72-b65bec09964a", "Loan Recommendation Multi-step");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        System.out.println(DMNRuntimeUtil.formatMessages(dmnModel.getMessages()));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        HashMap<String, Integer> loan = new HashMap<String, Integer>();
        loan.put("Amount", 100);
        loan.put("Rate", 12);
        loan.put("Term", 1);
        context.set("Loan", loan);
        DMNResult dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{"Loan Payment"});
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(0)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_93062144-ebc7-4ef7-a156-c342aeffac49"));
        Assert.assertThat((Object)((DMNMessage)dmnResult.getMessages().get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.ERROR_EVAL_NODE));
    }

    @Test
    public void testNPE() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("NPE.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_95b7ee22-1964-4be5-b7db-7db66692c707", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testUnionofLetters() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Union_of_letters.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_76362694-41e8-400c-8dea-e5f033d4f405", "Union of letters");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx1 = runtime.newContext();
        ctx1.set("A1", Arrays.asList("a", "b"));
        ctx1.set("A2", Arrays.asList("b", "c"));
        DMNResult dmnResult1 = runtime.evaluateAll(dmnModel, ctx1);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult1.getMessages()), (Object)dmnResult1.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((List)dmnResult1.getContext().get("D1")), (Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{"a", "b", "c"}));
        DMNContext ctx2 = runtime.newContext();
        ctx2.set("A1", Arrays.asList("a", "b"));
        ctx2.set("A2", Arrays.asList("b", "x"));
        DMNResult dmnResult2 = runtime.evaluateAll(dmnModel, ctx2);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult2.getMessages()), (Object)dmnResult2.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult2.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.ERROR_EVAL_NODE)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testUnknownVariable1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("unknown_variable1.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_9105d4a6-6049-4ace-a9cd-88f18d29bc8f", "Loan Recommendation - context");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertEquals((long)1L, (long)dmnModel.getMessages().stream().filter(m -> m.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL)).filter(m -> m.getMessage().contains("Unknown variable 'NonSalaryPct'")).count());
    }

    @Test
    public void testUnknownVariable2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("unknown_variable2.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_9105d4a6-6049-4ace-a9cd-88f18d29bc8f", "Loan Recommendation - context");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.ERR_COMPILING_FEEL));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getMessage(), (Matcher)CoreMatchers.containsString((String)"Unknown variable 'Borrower.liquidAssetsAmt'"));
    }

    @Test
    public void testSingleDecisionWithContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("SingleDecisionWithContext.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_71af58db-e1df-4b0f-aee2-48e0e8d89672", "SingleDecisionWithContext");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("MyDecision"), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void testEx_6_1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Ex_6_1.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5f1269c8-1e6f-4748-9eca-26aa1b1278ef", "Ex 6-1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx = runtime.newContext();
        HashMap<String, Object> t1 = new HashMap<String, Object>();
        t1.put("city", "Los Angeles");
        t1.put("name", "Los Angeles");
        t1.put("wins", 0);
        t1.put("losses", 1);
        t1.put("bonus points", 40);
        HashMap<String, Object> t2 = new HashMap<String, Object>();
        t2.put("city", "San Francisco");
        t2.put("name", "San Francisco");
        t2.put("wins", 1);
        t2.put("losses", 0);
        t2.put("bonus points", 7);
        ctx.set("NBA Pacific", Arrays.asList(t1, t2));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Number of distinct cities"), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)result.get("Second place losses"), (Matcher)CoreMatchers.is((Object)new BigDecimal(0)));
        Assert.assertThat((Object)result.get("Max wins"), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)result.get("Mean wins"), (Matcher)CoreMatchers.is((Object)new BigDecimal(0.5)));
        Assert.assertThat((Object)((List)result.get("Positions of Los Angeles teams")), (Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{new BigDecimal(1)}));
        Assert.assertThat((Object)result.get("Number of teams"), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)result.get("Sum of bonus points"), (Matcher)CoreMatchers.is((Object)new BigDecimal(47)));
    }

    @Test
    public void testSingletonlist_function_call() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("singletonlist_fuction_call.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_0768879b-5ee1-410f-92f0-7732573b069d", "expression function subst [a] with a");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx = runtime.newContext();
        ctx.set("InputLineItem", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0015"), DynamicTypeUtils.entry("Description", "additional Battery")));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("The Battery"), (Matcher)CoreMatchers.is(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0010"), DynamicTypeUtils.entry("Description", "Battery"))));
        Assert.assertThat((Object)((List)result.get("Remove Battery")), (Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0020"), DynamicTypeUtils.entry("Description", "Case")), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0030"), DynamicTypeUtils.entry("Description", "Power Supply"))}));
        Assert.assertThat((Object)((List)result.get("Remove Battery")), (Matcher)CoreMatchers.not((Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0010"), DynamicTypeUtils.entry("Description", "Battery"))})));
        Assert.assertThat((Object)((List)result.get("Insert before Line 0020")), (Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0010"), DynamicTypeUtils.entry("Description", "Battery")), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0015"), DynamicTypeUtils.entry("Description", "additional Battery")), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0020"), DynamicTypeUtils.entry("Description", "Case")), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Line", "0030"), DynamicTypeUtils.entry("Description", "Power Supply"))}));
    }

    @Test
    public void testJavaFunctionContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("java_function_context.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b42317c4-4f0c-474e-a0bf-2895b0b3c314", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx = runtime.newContext();
        ctx.set("Input", (Object)3.14);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)((BigDecimal)result.get("D1")).setScale(4, 4), (Matcher)CoreMatchers.is((Object)new BigDecimal("-1.0000")));
        Assert.assertThat((Object)((BigDecimal)result.get("D2")).setScale(4, 4), (Matcher)CoreMatchers.is((Object)new BigDecimal("-1.0000")));
    }

    @Test
    public void testJavaFunctionContext_withErrors() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("java_function_context_with_errors.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b42317c4-4f0c-474e-a0bf-2895b0b3c314", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
        List sourceIDs = dmnModel.getMessages().stream().map(m -> m.getSourceId()).collect(Collectors.toList());
        Assert.assertTrue((boolean)sourceIDs.contains("_a72a7aff-48c3-4806-83ca-fc1f1fe34320"));
        Assert.assertTrue((boolean)sourceIDs.contains("_a72a7aff-48c3-4806-83ca-fc1f1fe34321"));
    }

    @Test
    public void testPMMLFunctionContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("pmml_function_context.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b42317c4-4f0c-474e-a0bf-2895b0b3c314", "Dessin 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnModel.getMessages().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.INVALID_ATTRIBUTE_VALUE));
        Assert.assertThat((Object)((DMNMessage)dmnModel.getMessages().get(0)).getSeverity(), (Matcher)CoreMatchers.is((Object)DMNMessage.Severity.WARN));
    }

    @Test
    public void test_countCSATradeRatings() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("countCSATradeRatings.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_1a7d184c-2e38-4462-ae28-15591ef6d534", "countCSATradeRatings");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx = runtime.newContext();
        ArrayList ratings = new ArrayList();
        ratings.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Agency", "FITCH"), DynamicTypeUtils.entry("Value", "val1")));
        ratings.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Agency", "MOODY"), DynamicTypeUtils.entry("Value", "val2")));
        ctx.set("CSA Trade Ratings", ratings);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Trade Ratings"), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        DMNContext ctx2 = runtime.newContext();
        ctx2.set("CSA Trade Ratings", null);
        DMNResult dmnResult2 = runtime.evaluateAll(dmnModel, ctx2);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult2.getMessages()), (Object)dmnResult2.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result2 = dmnResult2.getContext();
        Assert.assertThat((Object)result2.get("Trade Ratings"), (Matcher)CoreMatchers.nullValue());
        DMNResult dmnResult3 = runtime.evaluateAll(dmnModel, runtime.newContext());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult3.getMessages()), (Object)dmnResult3.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult3.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testForLoopTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("PersonListHelloBKM.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ec5a78c7-a317-4c39-8310-db59be60f1c8", "PersonListHelloBKM");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        Map p1 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "John Doe"), DynamicTypeUtils.entry("Age", 33));
        Map p2 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "47"), DynamicTypeUtils.entry("Age", 47));
        context.set("My Input Data", Arrays.asList(p1, p2));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((List)result.get("My Decision")), (Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{"The person named John Doe is 33 years old.", "The person named 47 is 47 years old."}));
    }

    @Test
    public void testTypeInferenceForNestedContextAnonymousEntry() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("PersonListHelloBKM2.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_7e41a76e-2df6-4899-bf81-ae098757a3b6", "PersonListHelloBKM2");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        Map p1 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "John Doe"), DynamicTypeUtils.entry("Age", 33));
        Map p2 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "47"), DynamicTypeUtils.entry("Age", 47));
        context.set("My Input Data", Arrays.asList(p1, p2));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((List)result.get("My Decision")), (Matcher)org.hamcrest.Matchers.contains((Object[])new Object[]{DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Prof. John Doe"), DynamicTypeUtils.entry("Age", EvalHelper.coerceNumber((Object)33))), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Prof. 47"), DynamicTypeUtils.entry("Age", EvalHelper.coerceNumber((Object)47)))}));
    }

    @Test
    public void testSameEveryTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("same_every_type_check.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_09a13244-114d-43fb-9e00-cda89a2000dd", "same every type check");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.get("Some are even"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Every are even"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.get("Some are positive"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Every are positive"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Some are negative"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.get("Every are negative"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testDateAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("date_allowed_values.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_fbf002a3-615b-4f02-98e4-c28d4676225a", "Error with constraints verification");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext ctx = runtime.newContext();
        Object duration = BuiltInType.DURATION.fromString("P20Y");
        ctx.set("yearsMonth", duration);
        Object dateTime = BuiltInType.DATE_TIME.fromString("2017-05-16T17:58:00.000");
        ctx.set("dateTime", dateTime);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)result.get("Decision Logic 1")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"years and months", (Object)duration));
        Assert.assertThat((Object)((Map)result.get("Decision Logic 1")), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"Date Time", (Object)dateTime));
    }

    @Test
    public void testArtificialAttributes() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string-artificial-attributes.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
    }

    @Test
    public void testInvokeFunctionSuccess() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Caller.dmn", this.getClass(), "Calling.dmn");
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("My Name", (Object)"John Doe");
        context.set("My Number", (Object)3);
        context.set("Call ns", (Object)"http://www.trisotech.com/definitions/_88156d21-3acc-43b6-8b81-385caf0bb6ca");
        context.set("Call name", (Object)"Calling");
        context.set("Invoke decision", (Object)"Final Result");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Final decision"), (Matcher)CoreMatchers.is((Object)"The final decision is: Hello, John Doe your number once double is equal to: 6"));
    }

    @Test
    public void testInvokeFunctionWrongNamespace() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Caller.dmn", this.getClass(), "Calling.dmn");
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext wrongContext = DMNFactory.newContext();
        wrongContext.set("My Name", (Object)"John Doe");
        wrongContext.set("My Number", (Object)3);
        wrongContext.set("Call ns", (Object)"http://www.acme.com/a-wrong-namespace");
        wrongContext.set("Call name", (Object)"Calling");
        wrongContext.set("Invoke decision", (Object)"Final Result");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, wrongContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testInvokeFunctionWrongDecisionName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Caller.dmn", this.getClass(), "Calling.dmn");
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext wrongContext = DMNFactory.newContext();
        wrongContext.set("My Name", (Object)"John Doe");
        wrongContext.set("My Number", (Object)3);
        wrongContext.set("Call ns", (Object)"http://www.trisotech.com/definitions/_88156d21-3acc-43b6-8b81-385caf0bb6ca");
        wrongContext.set("Call name", (Object)"Calling");
        wrongContext.set("Invoke decision", (Object)"<unexistent decision>");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, wrongContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testInvokeFunctionCallerError() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Caller.dmn", this.getClass(), "Calling.dmn");
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext wrongContext = DMNFactory.newContext();
        wrongContext.set("My Name", (Object)"John Doe");
        wrongContext.set("My Number", (Object)"<not a number>");
        wrongContext.set("Call ns", (Object)"http://www.trisotech.com/definitions/_88156d21-3acc-43b6-8b81-385caf0bb6ca");
        wrongContext.set("Call name", (Object)"Calling");
        wrongContext.set("Invoke decision", (Object)"Final Result");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, wrongContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.getMessages().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testInvalidFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("InvalidFunction.dmn", this.getClass(), new String[0]);
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_84453b71-5d23-479f-9481-5196d92bacae", "0003-iteration-augmented");
        Assert.assertThat((Object)model, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Loans", new HashMap());
        DMNResult result = runtime.evaluateAll(model, context);
        List decisionResults = result.getDecisionResults();
        FEELStringMarshaller.INSTANCE.marshall(Arrays.asList(((DMNDecisionResult)decisionResults.get(0)).getResult(), ((DMNDecisionResult)decisionResults.get(1)).getResult()));
    }

    private Definitions buildSimplifiedDefinitions(String namespace, String ... decisions) {
        Definitions def = new Definitions();
        def.setNamespace(namespace);
        for (String d : decisions) {
            Decision dec = new Decision();
            dec.setName(d);
            def.getDrgElement().add(dec);
            def.addChildren((DMNModelInstrumentedBase)dec);
            dec.setParent((DMNModelInstrumentedBase)def);
        }
        return def;
    }

    private DecisionNodeImpl buildSimplifiedDecisionNode(Definitions def, String name) {
        return new DecisionNodeImpl(def.getDrgElement().stream().filter(drg -> drg.getName().equals(name)).filter(Decision.class::isInstance).map(Decision.class::cast).findFirst().get());
    }

    @Test
    public void testCycleDetection() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "a", "b");
        DecisionNodeImpl a = this.buildSimplifiedDecisionNode(defs, "a");
        DecisionNodeImpl b = this.buildSimplifiedDecisionNode(defs, "b");
        a.addDependency("b", (DMNNode)b);
        b.addDependency("a", (DMNNode)b);
        DMNModelImpl model = new DMNModelImpl();
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)a);
        model.addDecision((DecisionNode)b);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(this.getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assert.assertTrue((boolean)result.hasErrors());
    }

    @Test
    public void testCycleDetectionSelfReference() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "self");
        DecisionNodeImpl decision = this.buildSimplifiedDecisionNode(defs, "self");
        decision.addDependency("self", (DMNNode)decision);
        DMNModelImpl model = new DMNModelImpl();
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)decision);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(this.getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assert.assertTrue((boolean)result.hasErrors());
    }

    @Test
    public void testSharedDependency() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "a", "b", "c");
        DecisionNodeImpl a = this.buildSimplifiedDecisionNode(defs, "a");
        DecisionNodeImpl b = this.buildSimplifiedDecisionNode(defs, "b");
        DecisionNodeImpl c = this.buildSimplifiedDecisionNode(defs, "c");
        a.addDependency("c", (DMNNode)c);
        b.addDependency("c", (DMNNode)c);
        DMNModelImpl model = new DMNModelImpl();
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)a);
        model.addDecision((DecisionNode)b);
        model.addDecision((DecisionNode)c);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(this.getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assert.assertFalse((boolean)result.hasErrors());
    }

    @Test
    public void testCycleDetectionDeadlyDiamond() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "a", "b", "c", "d");
        DecisionNodeImpl a = this.buildSimplifiedDecisionNode(defs, "a");
        DecisionNodeImpl b = this.buildSimplifiedDecisionNode(defs, "b");
        DecisionNodeImpl c = this.buildSimplifiedDecisionNode(defs, "c");
        DecisionNodeImpl d = this.buildSimplifiedDecisionNode(defs, "d");
        a.addDependency("b", (DMNNode)b);
        a.addDependency("c", (DMNNode)c);
        b.addDependency("d", (DMNNode)d);
        c.addDependency("d", (DMNNode)d);
        DMNModelImpl model = new DMNModelImpl();
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)a);
        model.addDecision((DecisionNode)b);
        model.addDecision((DecisionNode)c);
        model.addDecision((DecisionNode)d);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(this.getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assert.assertFalse((boolean)result.hasErrors());
    }

    @Test
    public void testEx_4_3simplified() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Ex_4_3simplified.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5c5a9c72-627e-4666-ae85-31356fed3658", "Ex_4_3simplified");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("number", (Object)123.123456);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Formatted Monthly Payment"), (Matcher)CoreMatchers.is((Object)"\u20ac123.12"));
    }

    @Test
    public void testEx_4_3simplifiedASD() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Ex_4_3simplified.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5c5a9c72-627e-4666-ae85-31356fed3658", "Ex_4_3simplified");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("number", (Object)"ciao");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().stream().filter(m -> m.getMessageType() == DMNMessageType.ERROR_EVAL_NODE).anyMatch(m -> m.getMessage().endsWith("is not allowed by the declared type (DMNType{ http://www.omg.org/spec/FEEL/20140401 : number })")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDrools2125() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("drools2125.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_9f976b29-4cdd-42e9-8737-0ccbc2ad9498", "drools2125");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("person", (Object)"Bob");
        context.set("list of persons", Arrays.asList("Bob", "John"));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("person is Bob"), (Matcher)CoreMatchers.is((Object)"yes"));
        Assert.assertThat((Object)result.get("persons complies with UT list"), (Matcher)CoreMatchers.is((Object)"yes"));
        Assert.assertThat((Object)result.get("person on the list of persons"), (Matcher)CoreMatchers.is((Object)"yes"));
        Assert.assertThat((Object)result.get("persons complies with hardcoded list"), (Matcher)CoreMatchers.is((Object)"yes"));
        Assert.assertThat((Object)result.get("person is person"), (Matcher)CoreMatchers.is((Object)"yes"));
    }

    @Test
    public void testDROOLS2147() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DROOLS-2147.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_cbdacb7b-f72d-457d-b4f4-54020a06db24", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        List people = (List)resultContext.get("People");
        List peopleGroups = (List)resultContext.get("People groups");
        Assert.assertEquals((long)6L, (long)people.size());
        Assert.assertEquals((long)3L, (long)peopleGroups.size());
        Assert.assertEquals((long)2L, (long)((List)peopleGroups.get(0)).size());
        Assert.assertEquals((long)2L, (long)((List)peopleGroups.get(1)).size());
        Assert.assertEquals((long)2L, (long)((List)peopleGroups.get(2)).size());
    }

    @Test
    public void testDROOLS2147_message() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Ex_4_3simplified.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5c5a9c72-627e-4666-ae85-31356fed3658", "Ex_4_3simplified");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        StringBuilder sb = new StringBuilder("abcdefghijklmnopqrstuvwxyz");
        for (int i = 0; i < 100; ++i) {
            sb.append("abcdefghijklmnopqrstuvwxyz");
        }
        context.set("number", (Object)sb.toString());
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().stream().filter(m -> m.getMessageType() == DMNMessageType.ERROR_EVAL_NODE).anyMatch(m -> m.getMessage().contains("... [string clipped after 50 chars, total length is")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDROOLS2192() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("hardcoded_function_definition.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_99854980-65c8-4e9b-b365-bd30ded69f40", "hardcoded_function_definition");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        Assert.assertThat((Object)((BigDecimal)resultContext.get("hardcoded decision")).intValue(), (Matcher)CoreMatchers.is((Object)47));
    }

    @Test
    public void testDROOLS2200() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("will_be_null_if_negative.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c5889555-7ae5-4a67-a872-3a9492caf6e7", "will be null if negative");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a number", (Object)-1);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        Assert.assertThat(((Map)resultContext.get("will be null if negative")).get("s1"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat(((Map)resultContext.get("will be null if negative")).get("s2"), (Matcher)CoreMatchers.is((Object)"negative"));
    }

    @Test
    public void testDROOLS2201() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("typecheck_in_context_result.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_42bf043d-df86-48bd-9045-dfc08aa8ba0d", "typecheck in context result");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        Assert.assertThat(((Map)resultContext.get("an hardcoded person")).keySet(), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"name", "age"}));
        Assert.assertThat(((Map)resultContext.get("an hardcoded person with no name")).keySet(), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"age"}));
    }

    @Test
    public void testDROOLS2201b() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("typecheck_in_DT.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_99ccd4df-41ac-43c3-a563-d58f43149829", "typecheck in DT");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a number", (Object)0);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        Assert.assertThat((Object)((BigDecimal)resultContext.get("an odd decision")).intValue(), (Matcher)CoreMatchers.is((Object)47));
    }

    @Test
    public void testDROOLS2286() {
        DROOLS2286 johnCena = new DROOLS2286("John", "Cena");
        DROOLS2286 leslieBrown = new DROOLS2286("Leslie", "Brown");
        DROOLS2286 johnWick = new DROOLS2286("John", "Wick");
        ArrayList<DROOLS2286> personList = new ArrayList<DROOLS2286>();
        personList.add(johnCena);
        personList.add(leslieBrown);
        personList.add(johnWick);
        DMNContext context = DMNFactory.newContext();
        context.set("PersonList", personList);
        this.assertDROOLS2286(context);
    }

    @Test
    public void testDROOLS2286bis() {
        Map johnCena = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "John"), DynamicTypeUtils.entry("surname", "Cena"));
        Map leslieBrown = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "Leslie"), DynamicTypeUtils.entry("surname", "Brown"));
        Map johnWick = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "John"), DynamicTypeUtils.entry("surname", "Wick"));
        ArrayList personList = new ArrayList();
        personList.add(johnCena);
        personList.add(leslieBrown);
        personList.add(johnWick);
        DMNContext context = DMNFactory.newContext();
        context.set("PersonList", personList);
        this.assertDROOLS2286(context);
    }

    private void assertDROOLS2286(DMNContext context) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("FilterJohns.dmn", this.getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_feb9886e-22ce-469a-bbb6-096f13b71c7d", "FilterJohns");
        DMNResult result = runtime.evaluateAll(model, context);
        ArrayList resultObject = (ArrayList)result.getDecisionResultByName("PickAllJohns").getResult();
        Assert.assertEquals((long)2L, (long)resultObject.size());
    }

    @Test
    public void testVerifyExtendedKieFEELFunction_now() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("just_now.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_56fd6445-ff6a-4c28-8206-71fce7f80436", "just now");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("a decision just now").getResult(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testVerifyExtendedKieFEELFunction_today() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("just_today.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_56fd6445-ff6a-4c28-8206-71fce7f80436", "just today");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("a decision just today").getResult(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testEnhancedForLoop() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("drools2307.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_03d9481e-dcfc-4a59-9bdd-4f021cb2f0d8", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("an hardcoded forloop"), (Matcher)CoreMatchers.is(Arrays.asList(new BigDecimal(2), new BigDecimal(3), new BigDecimal(4))));
    }

    @Test
    public void testList_of_Vowels() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("List_of_Vowels.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_c5f007ce-4d45-4aac-8729-991d4abc7826", "List of Vowels");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)dmnResult.getMessages().stream().filter(m -> m.getMessageType() == DMNMessageType.ERROR_EVAL_NODE).anyMatch(m -> m.getSourceId().equals("_b2205027-d06c-41b5-8419-e14b501e14a6")), (Matcher)CoreMatchers.is((Object)true));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decide Vowel a"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)result.get("Decide BAD"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testEnhancedForLoop2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("MACD-enhanced_iteration.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6cfe7d88-6741-45d1-968c-b61a597d0964", "MACD-enhanced iteration");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        Map d1 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("aDate", LocalDate.of(2018, 3, 5)), DynamicTypeUtils.entry("Close", 1010));
        Map d2 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("aDate", LocalDate.of(2018, 3, 6)), DynamicTypeUtils.entry("Close", 1020));
        Map d3 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("aDate", LocalDate.of(2018, 3, 7)), DynamicTypeUtils.entry("Close", 1030));
        context.set("DailyTable", Arrays.asList(d1, d2, d3));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        Assert.assertThat(((Map)((List)resultContext.get("MACDTable")).get(0)).get("aDate"), (Matcher)CoreMatchers.is((Object)LocalDate.of(2018, 3, 5)));
        Assert.assertThat(((Map)((List)resultContext.get("MACDTable")).get(1)).get("aDate"), (Matcher)CoreMatchers.is((Object)LocalDate.of(2018, 3, 6)));
        Assert.assertThat(((Map)((List)resultContext.get("MACDTable")).get(2)).get("aDate"), (Matcher)CoreMatchers.is((Object)LocalDate.of(2018, 3, 7)));
    }

    @Test
    public void testNotListInDT() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("anot.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_292c1c7b-6b38-415d-938f-e9ca51d30b2b", "anot");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a letter", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("what letter decision"), (Matcher)CoreMatchers.is((Object)"vowel"));
    }

    @Test
    public void testListContainmentDT() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("list_containment_DT.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6ab2bd6d-adaa-45c4-a141-a84382a201eb", "list containment DT");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Passenger", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "Osama bin Laden")));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Boarding Status"), (Matcher)CoreMatchers.is((Object)"Denied"));
    }

    @Test
    public void testRelationwithemptycell() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("relation_with_empty_cell.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_99a00903-2943-47df-bab1-a32f276617ea", "Relation with empty cell");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decision A"), (Matcher)CoreMatchers.is(Arrays.asList(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", null), DynamicTypeUtils.entry("age", null)), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "John"), DynamicTypeUtils.entry("age", new BigDecimal(1))), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", null), DynamicTypeUtils.entry("age", null)), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "Matteo"), DynamicTypeUtils.entry("age", null)))));
    }

    @Test
    public void testFor() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Dynamic composition.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c2d86765-c3c7-4e1d-b1fa-b830fa5bc529", "Dynamic composition");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUsingReusableKeywordAsPartOfBKMName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("say_for_hello.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b6f2a9ca-a246-4f27-896a-e8ef04ea439c", "say for hello");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("just say"), (Matcher)CoreMatchers.is(Arrays.asList("Hello", "Hello", "Hello")));
    }

    @Test
    public void testProductFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("product.dmn", this.getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_40fdbc2c-a631-4ba4-8435-17571b5d1942", "Drawing 1");
        Assert.assertThat((Object)model, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(model.getMessages()), (Object)model.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("product", (Object)new HashMap<String, Object>(){
            {
                this.put("name", "Product1");
                this.put("type", 1);
            }
        });
        DMNDecisionResult result = runtime.evaluateAll(model, context).getDecisionResultByName("TestDecision");
        Assert.assertFalse((boolean)result.hasErrors());
        Assert.assertEquals((Object)"This is product 1", (Object)result.getResult());
    }

    @Test
    public void testNotWithPredicates20180601() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("test20180601.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_9b8f2642-2597-4a99-9fcd-f9302692d3dc", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context3 = DMNFactory.newContext();
        context3.set("my num", (Object)new BigDecimal(3));
        DMNResult dmnResult3 = runtime.evaluateAll(dmnModel, context3);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult3.getMessages()), (Object)dmnResult3.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult3.getDecisionResultByName("my decision").getResult(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context10 = DMNFactory.newContext();
        context10.set("my num", (Object)new BigDecimal(10));
        DMNResult dmnResult10 = runtime.evaluateAll(dmnModel, context10);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult10.getMessages()), (Object)dmnResult10.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult10.getDecisionResultByName("my decision").getResult(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testNotWithPredicates20180601b() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("BruceTask20180601.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_3802fcb2-5b93-4502-aff4-0f5c61244eab", "Bruce Task");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("TheBook", Arrays.asList(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Title", "55"), DynamicTypeUtils.entry("Price", new BigDecimal(5)), DynamicTypeUtils.entry("Quantity", new BigDecimal(5))), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Title", "510"), DynamicTypeUtils.entry("Price", new BigDecimal(5)), DynamicTypeUtils.entry("Quantity", new BigDecimal(10))), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Title", "810"), DynamicTypeUtils.entry("Price", new BigDecimal(8)), DynamicTypeUtils.entry("Quantity", new BigDecimal(10))), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Title", "85"), DynamicTypeUtils.entry("Price", new BigDecimal(8)), DynamicTypeUtils.entry("Quantity", new BigDecimal(5))), DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Title", "66"), DynamicTypeUtils.entry("Price", new BigDecimal(6)), DynamicTypeUtils.entry("Quantity", new BigDecimal(6)))));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Bruce"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Map.class)));
        Map bruce = (Map)result.get("Bruce");
        Assert.assertEquals((long)2L, (long)((List)bruce.get("one")).size());
        Assert.assertTrue((boolean)((List)bruce.get("one")).stream().filter(e -> ((Map)e).get("Title").equals("55")).findFirst().isPresent());
        Assert.assertTrue((boolean)((List)bruce.get("one")).stream().filter(e -> ((Map)e).get("Title").equals("510")).findFirst().isPresent());
        Assert.assertEquals((long)3L, (long)((List)bruce.get("two")).size());
        Assert.assertTrue((boolean)((List)bruce.get("two")).stream().filter(e -> ((Map)e).get("Title").equals("810")).findFirst().isPresent());
        Assert.assertTrue((boolean)((List)bruce.get("two")).stream().filter(e -> ((Map)e).get("Title").equals("85")).findFirst().isPresent());
        Assert.assertTrue((boolean)((List)bruce.get("two")).stream().filter(e -> ((Map)e).get("Title").equals("66")).findFirst().isPresent());
        Assert.assertEquals((long)1L, (long)((List)bruce.get("three")).size());
        Assert.assertTrue((boolean)((List)bruce.get("three")).stream().filter(e -> ((Map)e).get("Title").equals("510")).findFirst().isPresent());
        Assert.assertEquals((long)2L, (long)((List)bruce.get("Four")).size());
        Assert.assertTrue((boolean)((List)bruce.get("Four")).stream().filter(e -> ((Map)e).get("Title").equals("85")).findFirst().isPresent());
        Assert.assertTrue((boolean)((List)bruce.get("Four")).stream().filter(e -> ((Map)e).get("Title").equals("66")).findFirst().isPresent());
        Assert.assertEquals((long)2L, (long)((List)bruce.get("Five")).size());
        Assert.assertTrue((boolean)((List)bruce.get("Five")).stream().filter(e -> ((Map)e).get("Title").equals("85")).findFirst().isPresent());
        Assert.assertTrue((boolean)((List)bruce.get("Five")).stream().filter(e -> ((Map)e).get("Title").equals("66")).findFirst().isPresent());
        Assert.assertEquals((long)2L, (long)((List)bruce.get("six")).size());
        Assert.assertTrue((boolean)((List)bruce.get("six")).stream().filter(e -> ((Map)e).get("Title").equals("85")).findFirst().isPresent());
        Assert.assertTrue((boolean)((List)bruce.get("six")).stream().filter(e -> ((Map)e).get("Title").equals("66")).findFirst().isPresent());
    }

    @Test
    public void testModelById() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("simple-item-def.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModelById("https://github.com/kiegroup/kie-dmn/itemdef", "_simple-item-def");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testWeekdayOnDateDMN12() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("weekday-on-date.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_55a2dafd-ab4d-4154-bace-826d426da251", "weekday on date");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        for (int i = 0; i < 7; ++i) {
            DMNContext context = DMNFactory.newContext();
            context.set("Run Date", (Object)LocalDate.of(2018, 6, 25).plusDays(i));
            DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
            LOG.debug("{}", (Object)dmnResult);
            Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            DMNContext result = dmnResult.getContext();
            Assert.assertThat((Object)result.get("Weekday"), (Matcher)CoreMatchers.is((Object)new BigDecimal(i + 1)));
        }
    }

    @Test
    public void testDMN_Vs_FEEL_instanceof_interaction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Instance_of.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b5c4d644-5a15-4528-8028-86537cb1c836", "Instance of");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("input year month duration", (Object)Duration.parse("P12D"));
        context.set("input day time duration", (Object)Duration.parse("P1DT2H"));
        context.set("input date time", (Object)LocalDateTime.of(2018, 6, 28, 12, 34));
        context.set("input myType", (Object)LocalDate.of(2018, 6, 28));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decision Logic 1"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Decision Logic 2"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Decision Logic 3"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Decision Logic 4"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInvokingAFunctionOnALiteralContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("invokingAFunctionOnALiteralContext.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_781968dd-64dc-4231-9cd0-2ce590881f2c", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("invoking a function on a literal context"), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
    }

    public static class DROOLS2286 {
        private String name;
        private String surname;

        DROOLS2286(String name, String surname) {
            this.name = name;
            this.surname = surname;
        }

        public String getName() {
            return this.name;
        }

        public String getSurname() {
            return this.surname;
        }
    }
}

