/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.compiler.DMNOption;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.KieHelper;

public class DMNRuntimeTypeCheckTest {
    private static final KieServices ks = KieServices.Factory.get();

    @Test
    public void testDefaultNoTypeCheck() {
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        this.assertNoTypeCheck(runtime);
    }

    @Test
    public void testAskTypeCheckInKModule() {
        DMNRuntime runtime = this.getRuntimeWithTypeCheckOption("true", ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass()));
        this.assertPerformTypeCheck(runtime);
    }

    @Test
    public void testAskTypeCheckWithGlobalEnvVariable() {
        System.setProperty("org.kie.dmn.runtime.typecheck", "true");
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        this.assertPerformTypeCheck(runtime);
        System.clearProperty("org.kie.dmn.runtime.typecheck");
    }

    @Test
    public void testExplicitDisableTypeCheckInKModule() {
        DMNRuntime runtime = this.getRuntimeWithTypeCheckOption("false", ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass()));
        this.assertNoTypeCheck(runtime);
    }

    @Test
    public void testUnreckonOptionTypeCheckInKModuleDefaultsToNoTypeCheck() {
        DMNRuntime runtime = this.getRuntimeWithTypeCheckOption("boh", ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass()));
        this.assertNoTypeCheck(runtime);
    }

    @Test
    public void testEmptyOptionTypeCheckInKModuleDefaultsToNoTypeCheck() {
        DMNRuntime runtime = this.getRuntimeWithTypeCheckOption("", ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass()));
        this.assertNoTypeCheck(runtime);
    }

    @Test
    public void testDefaultNoTypeCheckButOverrideRuntime() {
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        ((DMNRuntimeImpl)runtime).setOption((DMNOption)new RuntimeTypeCheckOption(true));
        this.assertPerformTypeCheck(runtime);
    }

    @Test
    public void testExplicitDisableTypeCheckInKModuleButOverrideRuntime() {
        DMNRuntime runtime = this.getRuntimeWithTypeCheckOption("false", ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass()));
        ((DMNRuntimeImpl)runtime).setOption((DMNOption)new RuntimeTypeCheckOption(true));
        this.assertPerformTypeCheck(runtime);
    }

    @Test
    public void testAskTypeCheckInKModuleButOverrideRuntime() {
        DMNRuntime runtime = this.getRuntimeWithTypeCheckOption("true", ks.getResources().newClassPathResource("forTypeCheckTest.dmn", this.getClass()));
        ((DMNRuntimeImpl)runtime).setOption((DMNOption)new RuntimeTypeCheckOption(false));
        this.assertPerformTypeCheck(runtime);
    }

    private DMNRuntime getRuntimeWithTypeCheckOption(String typeCheckKModuleOption, Resource ... resources) {
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.runtime.typecheck", typeCheckKModuleOption);
        kfs.writeKModuleXML(kmm.toXML());
        for (Resource r : resources) {
            kfs.write(r);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        Assert.assertThat((String)results.getMessages().toString(), (Object)results.hasMessages(new Message.Level[]{Message.Level.ERROR}), (Matcher)CoreMatchers.is((Object)false));
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        return runtime;
    }

    private void assertNoTypeCheck(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6d8af9a2-dcf4-4b9e-8d90-6ccddc8c1bbd", "forTypeCheckTest");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a number", (Object)"ciao");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).stream().allMatch(m -> m.getSourceId().equals(dmnModel.getDecisionByName("hundred minus number").getId())), (Matcher)CoreMatchers.is((Object)true));
        DMNDecisionResult textPlusNumberDR = dmnResult.getDecisionResultByName("text plus number");
        Assert.assertThat((Object)textPlusNumberDR.getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED));
        Assert.assertThat((Object)textPlusNumberDR.getResult(), (Matcher)CoreMatchers.is((Object)"The input number is: ciao"));
        DMNDecisionResult hundredMinusNumber = dmnResult.getDecisionResultByName("hundred minus number");
        Assert.assertThat((Object)hundredMinusNumber.getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.FAILED));
    }

    private void assertPerformTypeCheck(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6d8af9a2-dcf4-4b9e-8d90-6ccddc8c1bbd", "forTypeCheckTest");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("a number", (Object)"ciao");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)("Should throw several errors, not only for 1 specific Decision: " + DMNRuntimeUtil.formatMessages(dmnResult.getMessages())), (Object)dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).stream().allMatch(m -> m.getSourceId().equals(dmnModel.getDecisionByName("hundred minus number").getId())), (Matcher)CoreMatchers.is((Object)false));
        DMNDecisionResult textPlusNumberDR = dmnResult.getDecisionResultByName("text plus number");
        Assert.assertThat((Object)textPlusNumberDR.getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.SKIPPED));
        DMNDecisionResult hundredMinusNumber = dmnResult.getDecisionResultByName("hundred minus number");
        Assert.assertThat((Object)textPlusNumberDR.getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.SKIPPED));
    }
}

