/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class DMNTypeTest {
    private static final DMNTypeRegistry typeRegistry = new DMNTypeRegistry();
    private static final DMNType FEEL_STRING = typeRegistry.resolveType("http://www.omg.org/spec/FEEL/20140401", "string");
    private static final DMNType FEEL_NUMBER = typeRegistry.resolveType("http://www.omg.org/spec/FEEL/20140401", "number");

    @Test
    public void testDROOLS2147() {
        String testNS = "testDROOLS2147";
        Map personPrototype = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", FEEL_STRING), DynamicTypeUtils.entry("age", FEEL_NUMBER));
        DMNType dmnPerson = typeRegistry.registerType((DMNType)new CompositeTypeImpl("testDROOLS2147", "person", null, false, personPrototype, null, null));
        DMNType dmnPersonList = typeRegistry.registerType((DMNType)new CompositeTypeImpl("testDROOLS2147", "personList", null, true, null, dmnPerson, null));
        DMNType dmnListOfPersonsGrouped = typeRegistry.registerType((DMNType)new CompositeTypeImpl("testDROOLS2147", "groups", null, true, null, dmnPersonList, null));
        Map instanceBob = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "Bob"), DynamicTypeUtils.entry("age", 42));
        Map instanceJohn = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "John"), DynamicTypeUtils.entry("age", 47));
        Map instanceNOTaPerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("name", "NOTAPERSON"));
        Assert.assertTrue((boolean)dmnPerson.isAssignableValue(instanceBob));
        Assert.assertTrue((boolean)dmnPerson.isAssignableValue(instanceJohn));
        Assert.assertFalse((boolean)dmnPerson.isAssignableValue(instanceNOTaPerson));
        List<Map> onlyBob = Arrays.asList(instanceBob);
        List<Map> bobANDjohn = Arrays.asList(instanceBob, instanceJohn);
        List<Map> johnANDnotAPerson = Arrays.asList(instanceJohn, instanceNOTaPerson);
        Assert.assertTrue((boolean)dmnPersonList.isAssignableValue(onlyBob));
        Assert.assertTrue((boolean)dmnPersonList.isAssignableValue(bobANDjohn));
        Assert.assertFalse((boolean)dmnPersonList.isAssignableValue(johnANDnotAPerson));
        Assert.assertTrue((boolean)dmnPersonList.isAssignableValue(instanceBob));
        List<List> the2ListsThatContainBob = Arrays.asList(onlyBob, bobANDjohn);
        Assert.assertTrue((boolean)dmnListOfPersonsGrouped.isAssignableValue(the2ListsThatContainBob));
        List<List> the3Lists = Arrays.asList(onlyBob, bobANDjohn, johnANDnotAPerson);
        Assert.assertFalse((boolean)dmnListOfPersonsGrouped.isAssignableValue(the3Lists));
        List<Object> groupsOfBobAndBobHimself = Arrays.asList(instanceBob, onlyBob, bobANDjohn);
        Assert.assertTrue((boolean)dmnListOfPersonsGrouped.isAssignableValue(groupsOfBobAndBobHimself));
        DMNType listOfGroups = typeRegistry.registerType((DMNType)new CompositeTypeImpl("testDROOLS2147", "listOfGroups", null, true, null, dmnListOfPersonsGrouped, null));
        List<Object> groupsContainingBobPartitionedBySize = Arrays.asList(the2ListsThatContainBob, Arrays.asList(bobANDjohn));
        Assert.assertTrue((boolean)listOfGroups.isAssignableValue(groupsContainingBobPartitionedBySize));
    }

    @Test
    public void testAllowedValuesForASimpleTypeCollection() {
        String testNS = "testDROOLS2357";
        FEEL feel = FEEL.newInstance();
        DMNType tDecision1 = typeRegistry.registerType((DMNType)new SimpleTypeImpl("testDROOLS2357", "tListOfVowels", null, true, feel.evaluateUnaryTests("\"a\",\"e\",\"i\",\"o\",\"u\""), FEEL_STRING, (Type)BuiltInType.STRING));
        Assert.assertTrue((boolean)tDecision1.isAssignableValue((Object)"a"));
        Assert.assertTrue((boolean)tDecision1.isAssignableValue(Arrays.asList("a")));
        Assert.assertFalse((boolean)tDecision1.isAssignableValue((Object)"z"));
        Assert.assertTrue((boolean)tDecision1.isAssignableValue(Arrays.asList("a", "e")));
        Assert.assertFalse((boolean)tDecision1.isAssignableValue(Arrays.asList("a", "e", "zzz")));
    }
}

